/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debug;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.Activator;

public final class Tracer {
    private Tracer() {
    }

    public static boolean isDebugging() {
        return Activator.getDefault().isDebugging();
    }

    public static void logInfo(String info, boolean raisedException) {
        Tracer.log(0, info, raisedException);
    }

    public static void logInfo(String info) {
        Tracer.logInfo("\n" + info, false);
    }

    public static void logError(String error, boolean raisedException) {
        Tracer.log(4, error, raisedException);
    }

    public static void log(int severity, String message, boolean raisedException) {
        if (Activator.getDefault() != null) {
            if (raisedException) {
                Activator.getDefault().getLog().log((IStatus)new Status(severity, "org.eclipse.ease", message, (Throwable)new Exception()));
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(severity, "org.eclipse.ease", message));
            }
        }
    }

    public static void logExceptionError(String message, Exception raisedException) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ease", message, (Throwable)raisedException));
    }

    public static void logExceptionWarning(String message, Exception raisedException) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ease", message, (Throwable)raisedException));
    }
}

