/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.preferences;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.preferences.PreferencesHelper;
import org.eclipse.ease.ui.preferences.URIValidator;
import org.eclipse.ease.ui.repository.IRawLocation;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.osgi.service.prefs.BackingStoreException;

public class LocationsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private final Set<IScriptLocation> fScriptLocations = new HashSet<IScriptLocation>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblProvideLocationsTo = new Label(container, 0);
        lblProvideLocationsTo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblProvideLocationsTo.setText("Provide locations to look for scripts. The default location will be used to store your recorded scripts.");
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tableViewer = new TableViewer(composite, 67584);
        final Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)table);
            }

            protected Object getValue(Object element) {
                if (element instanceof IScriptLocation) {
                    return ((IScriptLocation)element).getLocation();
                }
                return "";
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof IScriptLocation) {
                    ((IScriptLocation)element).setLocation(value.toString());
                    LocationsPage.this.tableViewer.update(element, null);
                }
            }
        });
        TableColumn tblclmnLocation = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnLocation, (ColumnLayoutData)new ColumnWeightData(5, 20, true));
        tblclmnLocation.setText("Location");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IScriptLocation) {
                    if (((IScriptLocation)element).isDefault()) {
                        return String.valueOf(((IScriptLocation)element).getLocation()) + " (default)";
                    }
                    return ((IScriptLocation)element).getLocation();
                }
                return super.getText(element);
            }

            public Font getFont(Object element) {
                if (element instanceof IScriptLocation && ((IScriptLocation)element).isDefault()) {
                    return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
                }
                return super.getFont(element);
            }
        });
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table);
            }

            protected Object getValue(Object element) {
                if (element instanceof IScriptLocation) {
                    return ((IScriptLocation)element).isRecursive();
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof IScriptLocation) {
                    ((IScriptLocation)element).setRecursive((Boolean)value);
                    LocationsPage.this.tableViewer.update(element, null);
                }
            }
        });
        TableColumn tblclmnRecursive = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnRecursive, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnRecursive.setText("Recursive");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IScriptLocation) {
                    return ((IScriptLocation)element).isRecursive() ? "true" : "false";
                }
                return super.getText(element);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IRawLocation && e2 instanceof IRawLocation) {
                    return ((IRawLocation)e1).getLocation().compareTo(((IRawLocation)e2).getLocation());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.tableViewer.setInput(this.fScriptLocations);
        Button btnAddWorkspace = new Button(container, 0);
        btnAddWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(LocationsPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select script folder");
                if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IPath) {
                    LocationsPage.this.addEntry("workspace:/" + result[0].toString());
                }
            }
        });
        btnAddWorkspace.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddWorkspace.setText("Add Workspace...");
        Button btnAddFileSystem = new Button(container, 0);
        btnAddFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(LocationsPage.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    LocationsPage.this.addEntry(new File(path).toURI().toString());
                }
            }
        });
        btnAddFileSystem.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddFileSystem.setText("Add File System...");
        Button btnAddUri = new Button(container, 0);
        btnAddUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(LocationsPage.this.getShell(), "Enter location URI", "Enter the URI of a location to add", "", (IInputValidator)new URIValidator());
                if (dialog.open() == 0) {
                    LocationsPage.this.addEntry(dialog.getValue());
                }
            }
        });
        btnAddUri.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddUri.setText("Add URI...");
        new Label(container, 0);
        Button btnSetAsDefault = new Button(container, 0);
        btnSetAsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LocationsPage.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Collection entries = (Collection)LocationsPage.this.tableViewer.getInput();
                    for (IScriptLocation entry : entries) {
                        entry.setDefault(entry.equals(selection.getFirstElement()));
                    }
                }
                LocationsPage.this.tableViewer.refresh();
            }
        });
        btnSetAsDefault.setLayoutData((Object)new GridData(4, 1024, false, true, 1, 1));
        btnSetAsDefault.setText("Default");
        Button btnDelete = new Button(container, 0);
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LocationsPage.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object location : selection.toList()) {
                        LocationsPage.this.fScriptLocations.remove(location);
                    }
                    boolean hasDefault = false;
                    for (IScriptLocation entry : LocationsPage.this.fScriptLocations) {
                        hasDefault |= entry.isDefault();
                    }
                    if (!hasDefault && !LocationsPage.this.fScriptLocations.isEmpty()) {
                        ((IScriptLocation)LocationsPage.this.fScriptLocations.iterator().next()).setDefault(true);
                    }
                    LocationsPage.this.tableViewer.refresh();
                }
            }
        });
        btnDelete.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        btnDelete.setText("Delete");
        this.performDefaults();
        return container;
    }

    private void addEntry(String location) {
        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
        entry.setLocation(location);
        entry.setRecursive(true);
        entry.setDefault(this.fScriptLocations.isEmpty());
        this.fScriptLocations.add(entry);
        this.tableViewer.refresh();
    }

    protected void performDefaults() {
        this.fScriptLocations.clear();
        this.fScriptLocations.addAll(PreferencesHelper.getLocations());
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            PreferencesHelper.clearLocations();
        }
        catch (BackingStoreException e) {
            Logger.logError((String)"Could not update script location preferences", (Throwable)e);
            return false;
        }
        for (IScriptLocation entry : this.fScriptLocations) {
            PreferencesHelper.addLocation(entry);
        }
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        repositoryService.updateLocations();
        return super.performOk();
    }
}

