/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesUIPlugin;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.internal.resources.semantic.util.ISemanticFileSystemLog;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

abstract class ActionBase
implements IObjectActionDelegate {
    static final QualifiedName DISABLE_ALL_SFS_ACTIONS = new QualifiedName("org.eclipse.ui.resources.semantic", "DisableAllSFSActions");
    private IStructuredSelection mySelection;
    private IWorkbenchPart myActivePart;
    private ISemanticFileSystemLog myLog;
    protected final int options = 0;

    ActionBase() {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myActivePart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.mySelection = (IStructuredSelection)selection;
        }
    }

    protected Shell getShell() {
        return this.myActivePart.getSite().getShell();
    }

    protected IStructuredSelection getSelection() {
        return this.mySelection;
    }

    protected boolean checkSelectionEnabled() {
        boolean shouldEnable = true;
        for (Object nextObject : this.getSelection()) {
            if (!(nextObject instanceof ISemanticResource)) {
                shouldEnable = false;
                break;
            }
            ISemanticResource sResource = (ISemanticResource)nextObject;
            IResource resource = sResource.getAdaptedResource();
            while (resource != null) {
                block6: {
                    ISemanticResource sRes = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
                    if (sRes == null) break;
                    try {
                        if (sRes.getPersistentProperty(DISABLE_ALL_SFS_ACTIONS) != null) {
                            shouldEnable = false;
                        }
                        break block6;
                    }
                    catch (CoreException coreException) {
                        shouldEnable = false;
                    }
                    break;
                }
                resource = resource.getParent();
            }
            if (!shouldEnable) break;
        }
        return shouldEnable;
    }

    protected boolean checkSelectionNonLocalOnly() {
        if (!this.checkSelectionEnabled()) {
            return false;
        }
        boolean shouldEnable = true;
        for (Object nextObject : this.getSelection()) {
            if (!(nextObject instanceof ISemanticResource)) {
                shouldEnable = false;
                break;
            }
            if (!(nextObject instanceof ISemanticFile)) continue;
            try {
                ISemanticResourceInfo attrs = ((ISemanticResource)nextObject).fetchResourceInfo(8, null);
                if (!attrs.isLocalOnly()) continue;
                shouldEnable = false;
                break;
            }
            catch (CoreException e) {
                this.log(e);
            }
        }
        return shouldEnable;
    }

    protected boolean checkSelectionSemanticResource() {
        if (!this.checkSelectionEnabled()) {
            return false;
        }
        boolean shouldEnable = true;
        for (Object nextObject : this.getSelection()) {
            if (nextObject instanceof ISemanticResource) continue;
            shouldEnable = false;
            break;
        }
        return shouldEnable;
    }

    protected boolean checkFilesWithReadOnlyFlagOnly(boolean readOnly) {
        if (!this.checkSelectionEnabled()) {
            return false;
        }
        boolean shouldEnable = true;
        for (Object nextObject : this.getSelection()) {
            if (!(nextObject instanceof ISemanticFile)) {
                shouldEnable = false;
                break;
            }
            try {
                ISemanticResourceInfo attrs = ((ISemanticResource)nextObject).fetchResourceInfo(16, null);
                if (readOnly == attrs.isReadOnly()) continue;
                shouldEnable = false;
                break;
            }
            catch (CoreException e) {
                this.log(e);
            }
        }
        return shouldEnable;
    }

    protected boolean checkSelectionLockingSupportedOnly() {
        if (!this.checkSelectionEnabled()) {
            return false;
        }
        boolean shouldEnable = true;
        for (Object nextObject : this.getSelection()) {
            if (!(nextObject instanceof ISemanticResource)) {
                shouldEnable = false;
                break;
            }
            try {
                ISemanticResourceInfo attrs = ((ISemanticResource)nextObject).fetchResourceInfo(4, null);
                if (attrs.isLockingSupported()) continue;
                shouldEnable = false;
                break;
            }
            catch (CoreException e) {
                this.log(e);
            }
        }
        return shouldEnable;
    }

    protected void run(IRunnableWithProgress runnable) {
        IProgressService srv = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        try {
            srv.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            String popupText = e.getMessage();
            if (popupText == null) {
                popupText = Messages.ActionBase_ActionNotCompleted_XMSG;
            }
            Status errorStatus = new Status(4, "org.eclipse.ui.resources.semantic", popupText, e.getCause());
            SemanticResourcesUIPlugin.handleError((IStatus)errorStatus, true);
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ActionBase_ActionCancelled_XGRP, (String)Messages.ActionBase_ActionCancelled_XMSG);
        }
    }

    private synchronized void log(CoreException ex) {
        if (this.myLog == null) {
            try {
                ISemanticFileSystem sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
                this.myLog = sfs.getLog();
                this.myLog.log(ex);
            }
            catch (CoreException coreException) {}
        } else {
            this.myLog.log(ex);
        }
    }
}

