/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class SemanticResourcesUIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ui.resources.semantic";
    public static final String IMG_REFRESH = "refresh";
    private static SemanticResourcesUIPlugin INSTANCE;
    private ImageRegistry imageRegistry;

    public static SemanticResourcesUIPlugin getInstance() {
        return INSTANCE;
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        if (throwable instanceof CoreException) {
            IStatus statusToShow;
            IStatus causeStatus = ((CoreException)throwable).getStatus();
            if (causeStatus.isMultiStatus()) {
                statusToShow = causeStatus;
            } else {
                MultiStatus status = new MultiStatus(PLUGIN_ID, 0, message, throwable);
                status.add(((CoreException)throwable).getStatus());
                statusToShow = status;
            }
            int style = 1;
            if (show) {
                style |= 2;
            }
            StatusManager.getManager().handle(statusToShow, style);
        } else {
            Status status = new Status(4, PLUGIN_ID, message, throwable);
            int style = 1;
            if (show) {
                style |= 2;
            }
            StatusManager.getManager().handle((IStatus)status, style);
        }
    }

    public static void handleError(IStatus status, boolean show) {
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
        this.imageRegistry = null;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            if (Display.getCurrent() != null) {
                this.imageRegistry = new ImageRegistry(Display.getCurrent());
            }
            if (PlatformUI.isWorkbenchRunning()) {
                this.imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            }
            this.imageRegistry.put(IMG_REFRESH, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/refresh.gif")));
        }
        return this.imageRegistry;
    }
}

