/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.internal.selector.SearchDestinationsSelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchDestinationsSelectorPageObject
extends InShellPageObject {
    private final List<ISearchDestination> destinationsToShow;
    private SearchDestinationsSelector selector;
    private final IDestinationsProvider destProvider;

    public SearchDestinationsSelectorPageObject(List<ISearchDestination> destinationsToShow, IDestinationsProvider destProvider) {
        this.destinationsToShow = destinationsToShow;
        this.destProvider = destProvider;
    }

    protected void createContent(Shell parent, FormToolkit formToolkit) {
        this.selector = new SearchDestinationsSelector((Composite)parent, formToolkit, 60, null){

            protected Set<IDestinationsProvider> getDestinationProvidersForCategory(IDestinationCategoryDescription category) {
                return new HashSet<IDestinationsProvider>(Arrays.asList(SearchDestinationsSelectorPageObject.this.destProvider));
            }

            protected List<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription category, IDestinationsProvider destinationsProvider) {
                return SearchDestinationsSelectorPageObject.this.destinationsToShow;
            }

            public void handleSelectionChange(ISearchDestination newSelection) {
            }
        };
    }

    public void setInput(final List<IDestinationCategoryDescription> input) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchDestinationsSelectorPageObject.this.selector.setInput(input);
            }
        });
    }

    private SWTBotTree destinationsTree() {
        return this.bot().tree();
    }

    public void selectFirstPossibleDestination() {
        this.destinationsTree().select(new SWTBotTreeItem[]{this.findFirstDestination()});
    }

    private SWTBotTreeItem findFirstDestination() {
        for (SWTBotTreeItem treeItem : this.getAllVisibleItems()) {
            if (!this.isDestination(treeItem)) continue;
            return treeItem;
        }
        throw new IllegalStateException("Could not find destinations");
    }

    private boolean isDestination(SWTBotTreeItem treeItem) {
        for (ISearchDestination dest : this.destinationsToShow) {
            if (!dest.getDisplayName().equals(treeItem.getText())) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllItemsNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (SWTBotTreeItem item : this.getAllVisibleItems()) {
            result.add(item.getText());
        }
        return result;
    }

    private List<SWTBotTreeItem> getAllVisibleItems() {
        return this.getItems(this.destinationsTree().getAllItems());
    }

    private List<SWTBotTreeItem> getItems(SWTBotTreeItem[] allItems) {
        ArrayList<SWTBotTreeItem> result = new ArrayList<SWTBotTreeItem>();
        SWTBotTreeItem[] sWTBotTreeItemArray = allItems;
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            result.add(item);
            result.addAll(this.getItems(item.getItems()));
            ++n2;
        }
        return result;
    }

    public void update() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchDestinationsSelectorPageObject.this.selector.update();
            }
        });
    }

    public void selectDestination(String destinationName) {
        for (SWTBotTreeItem item : this.getAllVisibleItems()) {
            if (!destinationName.equals(item.getText()) || !this.isDestination(item)) continue;
            item.select();
            return;
        }
        throw new WidgetNotFoundException(MessageFormat.format("Could not find destination {0}", destinationName));
    }

    public ISearchDestination getSelectedDestination() {
        return (ISearchDestination)UIThreadRunnable.syncExec((Result)new Result<ISearchDestination>(){

            public ISearchDestination run() {
                return SearchDestinationsSelectorPageObject.this.selector.getSelectedItem();
            }
        });
    }
}

