/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SearchDestinationsSelectorPageObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SearchDestinationsSelectorTest {
    private static final String DESTINATION_NAME_1 = "My First Destination";
    private static final String DESTINATION_NAME_2 = "My Second Destination";
    private static final String CATEGORY_NAME = "My Category";
    private List<ISearchDestination> destinationsToShow;
    private SearchDestinationsSelectorPageObject selector;
    private ISearchDestination destination_1;
    private ISearchDestination destination_2;

    @Before
    public void setUp() {
        this.destination_1 = this.mockDestination(DESTINATION_NAME_1);
        this.destination_2 = this.mockDestination(DESTINATION_NAME_2);
        this.destinationsToShow = new ArrayList<ISearchDestination>(Arrays.asList(this.destination_1));
        this.selector = new SearchDestinationsSelectorPageObject(this.destinationsToShow, this.createDestinationsProvider(this.destination_1, this.destination_2));
        this.selector.open();
        this.selector.setInput(Arrays.asList(this.mockCategory()));
    }

    @After
    public void tearDown() {
        this.selector.close();
    }

    @Test
    public void testUpdatingSelector() {
        this.selector.selectFirstPossibleDestination();
        this.verifyDisplayedItems(CATEGORY_NAME, DESTINATION_NAME_1);
        this.destinationsToShow.add(this.destination_2);
        this.selector.update();
        this.selector.selectFirstPossibleDestination();
        this.verifyDisplayedItems(CATEGORY_NAME, DESTINATION_NAME_1, DESTINATION_NAME_2);
    }

    @Test
    public void testUpdatingCurrentlySelectedItem() {
        this.selector.selectFirstPossibleDestination();
        this.verifyDisplayedItems(CATEGORY_NAME, DESTINATION_NAME_1);
        this.destinationsToShow.clear();
        this.destinationsToShow.add(this.destination_2);
        this.selector.update();
        this.selector.selectFirstPossibleDestination();
        this.selector.selectFirstPossibleDestination();
        this.verifyDisplayedItems(CATEGORY_NAME, DESTINATION_NAME_2);
    }

    @Test
    public void testSelectionIsPreservedWhenSameDestinationsAreShown() {
        this.destinationsToShow.add(this.destination_2);
        this.selector.update();
        this.selector.selectDestination(DESTINATION_NAME_2);
        this.destinationsToShow.remove(this.destination_1);
        this.selector.update();
        ISearchDestination selectedDestination = this.selector.getSelectedDestination();
        Assert.assertSame((String)"Destination 2 is not selected after update", (Object)this.destination_2, (Object)selectedDestination);
    }

    private void verifyDisplayedItems(String category, String ... destinations) {
        List<String> itemNames = this.selector.getAllItemsNames();
        int expectedItemsCount = destinations.length + 1;
        Assert.assertEquals((String)MessageFormat.format("{0} items expected", expectedItemsCount), (long)expectedItemsCount, (long)itemNames.size());
        Assert.assertTrue((String)MessageFormat.format("Destination category '{0}' not found", category), (boolean)itemNames.contains(category));
        String[] stringArray = destinations;
        int n = destinations.length;
        int n2 = 0;
        while (n2 < n) {
            String destName = stringArray[n2];
            Assert.assertTrue((String)MessageFormat.format("Destinaion '{0}' not shown", destName), (boolean)itemNames.contains(destName));
            ++n2;
        }
    }

    private IDestinationCategoryDescription mockCategory() {
        IDestinationCategoryDescription cat = (IDestinationCategoryDescription)Mockito.mock(IDestinationCategoryDescription.class);
        Mockito.stub((Object)cat.getDisplayName()).toReturn((Object)CATEGORY_NAME);
        return cat;
    }

    private IDestinationsProvider createDestinationsProvider(ISearchDestination ... destinations) {
        HashSet<ISearchDestination> destinationSet = new HashSet<ISearchDestination>(Arrays.asList(destinations));
        IDestinationsProvider provider = (IDestinationsProvider)Mockito.mock(IDestinationsProvider.class);
        Mockito.stub((Object)provider.getSearchDestinations()).toReturn(destinationSet);
        return provider;
    }

    private ISearchDestination mockDestination(String destinationName) {
        ISearchDestination dest = (ISearchDestination)Mockito.mock(ISearchDestination.class);
        Mockito.stub((Object)dest.getDisplayName()).toReturn((Object)destinationName);
        return dest;
    }
}

