/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes.DestinationNode;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;

public class CategoryNode {
    private final String displayName;
    private final Set<ISearchDestination> destinations;
    private final IDestinationsProviderDescription destinationProvider;
    private final String destinationProviderId;

    public CategoryNode(String displayName, IDestinationsProviderDescription destinationProvider) {
        this.displayName = displayName;
        this.destinations = destinationProvider.createProvider().getSearchDestinations();
        this.destinationProvider = destinationProvider;
        this.destinationProviderId = destinationProvider.getId();
    }

    public List<DestinationNode> getDestinations() {
        ArrayList<DestinationNode> result = new ArrayList<DestinationNode>();
        for (ISearchDestination destination : this.destinations) {
            DestinationNode destinationNode = new DestinationNode(this, destination);
            result.add(destinationNode);
        }
        return result;
    }

    public int getDestinationsCount() {
        return this.destinations.size();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDestinationProviderId() {
        return this.destinationProvider.getId();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destinationProviderId == null ? 0 : this.destinationProviderId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryNode other = (CategoryNode)obj;
        return !(this.destinationProviderId == null ? other.destinationProviderId != null : !this.destinationProviderId.equals(other.destinationProviderId));
    }
}

