/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;

public class ObservableValueContractTest
extends ObservableContractTest {
    private IObservableValueContractDelegate delegate;
    private IObservableValue observable;
    static /* synthetic */ Class class$0;

    public ObservableValueContractTest(IObservableValueContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public ObservableValueContractTest(String testName, IObservableValueContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
    }

    public void testChange_ValueChangeEvent() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        this.delegate.change((IObservable)this.observable);
        ObservableValueContractTest.assertEquals((String)this.formatFail("On change value change listeners should be notified."), (int)1, (int)listener.count);
    }

    public void testGetValueType_ExpectedType() throws Exception {
        ObservableValueContractTest.assertEquals((String)this.formatFail("Type of the value should be returned from getType()."), (Object)this.delegate.getValueType(this.observable), (Object)this.observable.getValueType());
    }

    public void testChange_OrderOfNotifications() throws Exception {
        final ArrayList listeners = new ArrayList();
        IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                listeners.add(this);
            }
        };
        IValueChangeListener valueChangeListener = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                listeners.add(this);
            }
        };
        this.observable.addChangeListener(changeListener);
        this.observable.addValueChangeListener(valueChangeListener);
        this.delegate.change((IObservable)this.observable);
        ObservableValueContractTest.assertTrue((String)this.formatFail("Change Listeners were not notified on change."), (listeners.size() > 0 ? 1 : 0) != 0);
        ObservableValueContractTest.assertEquals((String)this.formatFail("Change listeners should be notified before value change listeners."), (Object)changeListener, listeners.get(0));
        ObservableValueContractTest.assertEquals((String)this.formatFail("Value change listeners should be notified after change listeners."), (Object)valueChangeListener, listeners.get(1));
    }

    public void testChange_ValueChangeEventDiff() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        Object oldValue = this.observable.getValue();
        this.delegate.change((IObservable)this.observable);
        ValueChangeEvent event = listener.event;
        ObservableValueContractTest.assertTrue((String)this.formatFail("Change Listeners were not notified on change."), (listener.count > 0 ? 1 : 0) != 0);
        ObservableValueContractTest.assertEquals((String)this.formatFail("When a value change event is fired the old value should be the previous value of the observable value."), (Object)oldValue, (Object)event.diff.getOldValue());
        ObservableValueContractTest.assertEquals((String)this.formatFail("When a value change event is fired the new value should be the same as the current value of the observable value."), (Object)this.observable.getValue(), (Object)event.diff.getNewValue());
    }

    public void testChange_ValueChangeEventFiredAfterValueIsSet() throws Exception {
        class ValueChangeListener
        implements IValueChangeListener {
            Object value;
            final /* synthetic */ ObservableValueContractTest this$0;

            ValueChangeListener(ObservableValueContractTest observableValueContractTest) {
                this.this$0 = observableValueContractTest;
            }

            public void handleValueChange(ValueChangeEvent event) {
                this.value = event.getObservableValue().getValue();
            }
        }
        ValueChangeListener listener = new ValueChangeListener(this);
        this.observable.addValueChangeListener((IValueChangeListener)listener);
        this.delegate.change((IObservable)this.observable);
        ObservableValueContractTest.assertEquals((String)this.formatFail("When a value change event is fired the new value should be applied before firing the change event."), (Object)listener.value, (Object)this.observable.getValue());
    }

    public void testRemoveValueChangeListener_RemovesListener() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        this.delegate.change((IObservable)this.observable);
        ObservableValueContractTest.assertEquals((String)this.formatFail("Value change listeners should be notified on change."), (int)1, (int)listener.count);
        this.observable.removeValueChangeListener((IValueChangeListener)listener);
        this.delegate.change((IObservable)this.observable);
        ObservableValueContractTest.assertEquals((String)this.formatFail("Value change listeners should not be notified after they've been removed from the observable."), (int)1, (int)listener.count);
    }

    public void testGetValue_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            public void run() {
                ObservableValueContractTest.this.observable.getValue();
            }
        }, this.formatFail("IObservableValue.getValue()"), (IObservable)this.observable);
    }

    public void testGetValue_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            public void run() {
                ObservableValueContractTest.this.observable.getValue();
            }
        }, (CurrentRealm)this.observable.getRealm());
    }

    public static Test suite(IObservableValueContractDelegate delegate) {
        SuiteBuilder suiteBuilder = new SuiteBuilder();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.databinding.conformance.ObservableValueContractTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return suiteBuilder.addObservableContractTest(clazz, delegate).build();
    }
}

