/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet035PostSelectionProvider {
    private DataBindingContext dbc;
    private ListViewer listViewer;

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Shell shell = new Snippet035PostSelectionProvider().createShell();
                Display display = Display.getCurrent();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private Shell createShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        shell.setText("Post Selections");
        shell.setLayout((Layout)new GridLayout(1, false));
        this.dbc = new DataBindingContext();
        this.createTableSection((Composite)shell);
        this.createFieldSection((Composite)shell);
        shell.pack();
        shell.open();
        return shell;
    }

    private void createTableSection(Composite parent) {
        Group section = this.createSectionGroup(parent, 1);
        this.listViewer = new ListViewer((Composite)section, 2052);
        GridDataFactory.fillDefaults().grab(true, true).hint(250, 250).applyTo((Control)this.listViewer.getList());
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] names = new String[]{"John Doe", "Steve Northover", "Grant Gayed", "Veronika Irvine", "Mike Wilson", "Christophe Cornu", "Lynne Kues", "Silenio Quarti"};
        this.listViewer.setInput((Object)names);
    }

    private void createFieldSection(Composite parent) {
        Group section = this.createSectionGroup(parent, 2);
        Label selectionLabel = Snippet035PostSelectionProvider.createLabelField((Composite)section, "Selection:");
        IViewerObservableValue selectionObservable = ViewerProperties.singleSelection().observe((Viewer)this.listViewer);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Label)selectionLabel), (IObservableValue)selectionObservable);
        Label postSelectionLabel = Snippet035PostSelectionProvider.createLabelField((Composite)section, "Post selection:");
        IViewerObservableValue postSelectionObservable = ViewerProperties.singlePostSelection().observe((Viewer)this.listViewer);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Label)postSelectionLabel), (IObservableValue)postSelectionObservable);
    }

    private Group createSectionGroup(Composite parent, int numColumns) {
        Group section = new Group(parent, 16);
        GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(false).margins(5, 5).spacing(15, 5).applyTo((Composite)section);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        return section;
    }

    private static Label createLabelField(Composite parent, String labelText) {
        Label nameLabel = new Label(parent, 16384);
        nameLabel.setText(labelText);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        Label contentLabel = new Label(parent, 16384);
        GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).applyTo((Control)contentLabel);
        return contentLabel;
    }
}

