/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IElementComparer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckableCheckedElementsObservableSet
extends AbstractObservableSet<Object> {
    private ICheckable checkable;
    private Set<Object> wrappedSet;
    private Object elementType;
    private IElementComparer elementComparer;
    private ICheckStateListener listener;

    public CheckableCheckedElementsObservableSet(Realm realm, final Set<Object> wrappedSet, Object elementType, IElementComparer elementComparer, ICheckable checkable) {
        super(realm);
        Assert.isNotNull((Object)checkable, (String)"Checkable cannot be null");
        Assert.isNotNull(wrappedSet, (String)"Wrapped set cannot be null");
        this.checkable = checkable;
        this.wrappedSet = wrappedSet;
        this.elementType = elementType;
        this.elementComparer = elementComparer;
        this.listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (event.getChecked()) {
                    if (wrappedSet.add(element)) {
                        CheckableCheckedElementsObservableSet.this.fireSetChange(Diffs.createSetDiff(Collections.singleton(element), Collections.emptySet()));
                    }
                } else if (wrappedSet.remove(element)) {
                    CheckableCheckedElementsObservableSet.this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(element)));
                }
            }
        };
        checkable.addCheckStateListener(this.listener);
    }

    protected Set<Object> getWrappedSet() {
        return this.wrappedSet;
    }

    Set<Object> createDiffSet() {
        return ViewerElementSet.withComparer(this.elementComparer);
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Class<Object> getElementClass() {
        return Object.class;
    }

    public boolean add(Object o) {
        this.getterCalled();
        boolean added = this.wrappedSet.add(o);
        if (added) {
            this.checkable.setChecked(o, true);
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), Collections.emptySet()));
        }
        return added;
    }

    public boolean remove(Object o) {
        this.getterCalled();
        boolean removed = this.wrappedSet.remove(o);
        if (removed) {
            this.checkable.setChecked(o, false);
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(o)));
        }
        return removed;
    }

    public boolean addAll(Collection<? extends Object> c) {
        boolean changed;
        this.getterCalled();
        Set<Object> additions = this.createDiffSet();
        for (Object object : c) {
            if (!this.wrappedSet.add(object)) continue;
            this.checkable.setChecked(object, true);
            additions.add(object);
        }
        boolean bl = changed = !additions.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(additions, Collections.emptySet()));
        }
        return changed;
    }

    public boolean removeAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        Set<Object> removals = this.createDiffSet();
        for (Object element : c) {
            if (!this.wrappedSet.remove(element)) continue;
            this.checkable.setChecked(element, false);
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removals));
        }
        return changed;
    }

    public boolean retainAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        Set<Object> toRetain = this.createDiffSet();
        toRetain.addAll(c);
        Set<Object> removals = this.createDiffSet();
        Iterator<Object> iterator = this.wrappedSet.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (toRetain.contains(element)) continue;
            iterator.remove();
            this.checkable.setChecked(element, false);
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removals));
        }
        return changed;
    }

    public void clear() {
        this.getterCalled();
        Set<Object> removals = this.createDiffSet();
        removals.addAll(this.wrappedSet);
        this.removeAll(removals);
    }

    public Iterator<Object> iterator() {
        this.getterCalled();
        final Iterator<Object> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<Object>(){
            private Object last = null;

            @Override
            public boolean hasNext() {
                CheckableCheckedElementsObservableSet.this.getterCalled();
                return wrappedIterator.hasNext();
            }

            @Override
            public Object next() {
                CheckableCheckedElementsObservableSet.this.getterCalled();
                this.last = wrappedIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                CheckableCheckedElementsObservableSet.this.getterCalled();
                wrappedIterator.remove();
                CheckableCheckedElementsObservableSet.this.checkable.setChecked(this.last, false);
                CheckableCheckedElementsObservableSet.this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(this.last)));
            }
        };
    }

    public synchronized void dispose() {
        if (this.checkable != null) {
            this.checkable.removeCheckStateListener(this.listener);
            this.checkable = null;
            this.listener = null;
        }
        super.dispose();
    }
}

