/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

public class CTabFolderElement
extends CompositeElement {
    private static final String BACKGROUND_SET_BY_TAB_RENDERER = "bgSetByTabRenderer";

    public CTabFolderElement(CTabFolder tabFolder, CSSEngine engine) {
        super((Composite)tabFolder, engine);
    }

    @Override
    protected void computeStaticPseudoInstances() {
        super.computeStaticPseudoInstances();
        super.addStaticPseudoInstance("selected");
    }

    @Override
    public Node item(int index) {
        Widget widget = this.getWidget();
        CTabFolder folder = (CTabFolder)widget;
        int length = folder.getChildren().length;
        if (index >= length) {
            CTabItem w = folder.getItem(index - length);
            return this.getElement(w);
        }
        Control w = folder.getChildren()[index];
        return this.getElement(w);
    }

    @Override
    public int getLength() {
        Widget widget = this.getWidget();
        int childCount = 0;
        if (widget instanceof Composite) {
            childCount = ((Composite)widget).getChildren().length;
            if (widget instanceof CTabFolder) {
                childCount += ((CTabFolder)widget).getItemCount();
            }
        }
        return childCount;
    }

    @Override
    public void reset() {
        super.reset();
        CTabFolder folder = (CTabFolder)this.getWidget();
        folder.setSelectionBackground(null);
        folder.setSelectionForeground(null);
        folder.setBackground(null, null);
        this.resetChildrenBackground((Composite)folder);
        if (folder.getRenderer() instanceof ICTabRendering) {
            ICTabRendering renderer = (ICTabRendering)folder.getRenderer();
            folder.setRenderer(null);
            renderer.setSelectedTabFill(null);
            renderer.setTabOutline(null);
            renderer.setInnerKeyline(null);
            renderer.setOuterKeyline(null);
            renderer.setShadowColor(null);
        }
    }

    private void resetChildrenBackground(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            this.resetChildBackground(control);
            if (control instanceof Composite) {
                this.resetChildrenBackground((Composite)control);
            }
            ++n2;
        }
    }

    private void resetChildBackground(Control control) {
        Color backgroundSetByRenderer = (Color)control.getData(BACKGROUND_SET_BY_TAB_RENDERER);
        if (backgroundSetByRenderer != null) {
            if (control.getBackground() == backgroundSetByRenderer) {
                control.setBackground(null);
            }
            control.setData(BACKGROUND_SET_BY_TAB_RENDERER, null);
        }
    }

    public static void setBackgroundOverriddenDuringRenderering(Composite composite, Color background) {
        composite.setBackground(background);
        composite.setData(BACKGROUND_SET_BY_TAB_RENDERER, (Object)background);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!CompositeElement.hasBackgroundOverriddenByCSS(control)) {
                control.setBackground(background);
                control.setData(BACKGROUND_SET_BY_TAB_RENDERER, (Object)background);
            }
            ++n2;
        }
    }
}

