/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.tools.services.IResourceProviderService;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BasicResourceProvider
implements IResourceProviderService {
    protected Map<String, String> properties;
    protected BundleContext context;

    public void activate(BundleContext context, Map<String, String> properties) {
        this.properties = properties;
        this.context = context;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Image getImage(Display display, String key) {
        URL url = FileLocator.find((Bundle)this.context.getBundle(), (IPath)new Path(this.properties.get(key)), null);
        if (url == null) return null;
        InputStream stream = null;
        stream = url.openStream();
        Image image = new Image((Device)display, stream);
        if (stream == null) return image;
        try {
            stream.close();
            return image;
        }
        catch (IOException iOException) {}
        return image;
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (stream == null) return null;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    @Override
    public Font getFont(Display display, String key) {
        return null;
    }

    @Override
    public Color getColor(Display display, String key) {
        String color = this.properties.get(key);
        if (color.startsWith("rgb")) {
            String rgb = color.substring(color.indexOf(40) + 1, color.indexOf(41));
            String[] cols = rgb.split(",");
            int r = Integer.parseInt(cols[0].trim());
            int g = Integer.parseInt(cols[1].trim());
            int b = Integer.parseInt(cols[2].trim());
            return new Color((Device)display, new RGB(r, g, b));
        }
        return null;
    }
}

