/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.orion.css.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.orion.css.editor.Activator;
import org.eclipse.e4.tools.orion.editor.builder.IHTMLBuilder;
import org.eclipse.e4.tools.orion.editor.builder.css.E4CSSBuilder;
import org.eclipse.e4.tools.orion.editor.swt.OrionEditorControl;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;

public class CSSEditorPreferences
extends PreferencePageEnhancer {
    ITheme selection;
    IThemeEngine engine;
    boolean resetCurrentTheme;
    private OrionEditorControl editor;
    private String editorContent;
    private Path filePath;

    public void createContents(Composite parent) {
        this.resetCurrentTheme = false;
        IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MWindow hostWin = (MWindow)wbw.getService(MWindow.class);
        EPartService cfr_ignored_0 = (EPartService)hostWin.getContext().get(EPartService.class);
        EModelService cfr_ignored_1 = (EModelService)hostWin.getContext().get(EModelService.class);
        this.engine = (IThemeEngine)hostWin.getContext().get(IThemeEngine.class);
        try {
            this.initContent();
            Composite composite3 = new Composite(parent, 2048);
            composite3.setLayout((Layout)new FillLayout());
            GridData data = new GridData(4, 4, true, true, 2, 2);
            data.widthHint = 500;
            data.heightHint = 500;
            composite3.setLayoutData((Object)data);
            this.editor = new OrionEditorControl(composite3, 0, (IHTMLBuilder)E4CSSBuilder.getInstance());
            this.editor.setText(this.editorContent);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to load CSS", (Throwable)e));
            return;
        }
    }

    private void initContent() throws MalformedURLException, IOException {
        ITheme theme = this.selection;
        List sheets = ((ThemeEngine)this.engine).getStylesheets(theme);
        List mod = ((ThemeEngine)this.engine).getModifiedStylesheets(this.selection);
        if (mod.size() > 0) {
            sheets = mod;
        }
        if (sheets.size() > 0) {
            String path = (String)sheets.get(0);
            URL fileURL = FileLocator.toFileURL((URL)new URL(path));
            InputStream in = fileURL.openStream();
            this.filePath = new Path(fileURL.getPath());
            this.editorContent = this.loadFile(in, 1024);
        } else {
            this.editorContent = "/*\n * This is an Orion editor sample.\n */\nfunction() {\n    var a = 'hi there!';\n    window.console.log(a);\n}";
        }
    }

    public String loadFile(InputStream in, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        try {
            int size = ((Reader)reader).read(buffer, 0, buffer.length);
            while (size > 0) {
                out.append(buffer, 0, size);
                size = ((Reader)reader).read(buffer, 0, buffer.length);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return out.toString();
    }

    public void setSelection(Object sel) {
        if (sel instanceof ITheme) {
            ITheme newTheme = (ITheme)sel;
            ITheme oldSelection = this.selection;
            this.selection = newTheme;
            if (oldSelection != null && !newTheme.getId().equals(oldSelection.getId())) {
                try {
                    if (!this.editor.isDisposed()) {
                        this.initContent();
                        this.editor.setText(this.editorContent);
                        this.editor.setDirty(false);
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to load CSS", (Throwable)e));
                    return;
                }
            }
        }
    }

    private boolean isDirty() {
        return this.editor.isDirty();
    }

    /*
     * Unable to fully structure code
     */
    public void performOK() {
        if (this.isDirty()) {
            block27: {
                configLocation = Platform.getConfigurationLocation();
                e4CSSPath = null;
                try {
                    locationURL = new URL(configLocation.getDataArea("org.eclipse.e4.ui.css.swt.theme").toString());
                    locationFile = new File(locationURL.getFile());
                    e4CSSPath = locationFile.getPath();
                    if (!locationFile.exists()) {
                        locationFile.mkdirs();
                    }
                }
                catch (IOException e1) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to create config CSS", (Throwable)e1));
                    return;
                }
                path = new Path(String.valueOf(e4CSSPath) + System.getProperty("file.separator") + this.filePath.lastSegment());
                rc = this.editor.getText();
                if (!(rc instanceof String)) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to retrieve editor content " + rc));
                    return;
                }
                bytes = rc.getBytes();
                outputStream = null;
                try {
                    outputStream = new FileOutputStream(path.toOSString());
                    outputStream.write(bytes, 0, bytes.length);
                }
                catch (FileNotFoundException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to write CSS", (Throwable)e));
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block27;
                }
                catch (IOException e) {
                    try {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to write CSS", (Throwable)e));
                        ** if (outputStream == null) goto lbl-1000
                    }
                    catch (Throwable var8_11) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var8_11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            outputStream.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block27;
                    }
                }
                if (outputStream == null) break block27;
                try {
                    outputStream.close();
                }
                catch (IOException v3) {}
            }
            if (this.engine instanceof ThemeEngine) {
                styleSheets = new ArrayList<String>();
                try {
                    styleSheetURL = path.toFile().toURI().toURL();
                    styleSheets.add(styleSheetURL.toString());
                    ((ThemeEngine)this.engine).themeModified(this.selection, styleSheets);
                }
                catch (MalformedURLException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to update CSS Theme", (Throwable)e));
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to update CSS Theme", (Throwable)e));
                }
            }
        }
        if (this.resetCurrentTheme) {
            ((ThemeEngine)this.engine).resetCurrentTheme();
            this.resetCurrentTheme = false;
        }
    }

    public void performCancel() {
    }

    public void performDefaults() {
        List mod = ((ThemeEngine)this.engine).getModifiedStylesheets(this.selection);
        if (mod.size() > 0) {
            String path = (String)mod.get(0);
            try {
                URL styleSheetURL = FileLocator.toFileURL((URL)new URL(path));
                File file = new File(styleSheetURL.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.engine instanceof ThemeEngine) {
            ((ThemeEngine)this.engine).resetModifiedStylesheets(this.selection);
        }
        try {
            this.initContent();
            this.editor.setText(this.editorContent);
            this.editor.setDirty(false);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "z.ex.css.editor", "Failed to load CSS", (Throwable)e));
            return;
        }
        this.resetCurrentTheme = true;
    }
}

