/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BindingContextSelectionDialog;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BindingTableEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private IListProperty BINDING_TABLE__BINDINGS = EMFProperties.list((EStructuralFeature)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS);
    private StackLayout stackLayout;
    private List<Action> actions = new ArrayList<Action>();

    @Inject
    public BindingTableEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.BindingTableEditor_AddKeyBinding, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.KeyBinding")){

            public void run() {
                BindingTableEditor.this.handleAddKeyBinding();
            }
        });
    }

    @Override
    public Image getImage(Object element, Display display) {
        return this.createImage("IMG_org.eclipse.e4.tools.emf.ui.modelelements.BindingTable");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.BindingTableEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.BindingTableEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), false);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, (IObservableValue)this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, IObservableValue master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        Label l = new Label(parent, 0);
        l.setText(this.Messages.ModelTooling_Common_Id);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(this.Messages.BindingTableEditor_ContextId);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.BINDING_TABLE__BINDING_CONTEXT, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID})).observeDetail((IObservableValue)this.getMaster()));
        final Button b = new Button(parent, 0x800008);
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd;
                BindingContextSelectionDialog dialog = new BindingContextSelectionDialog(b.getShell(), BindingTableEditor.this.getEditor().getModelProvider(), BindingTableEditor.this.Messages);
                if (dialog.open() == 0 && (cmd = SetCommand.create((EditingDomain)BindingTableEditor.this.getEditingDomain(), (Object)BindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDING_CONTEXT, (Object)dialog.getSelectedContext())).canExecute()) {
                    BindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.BindingTableEditor_Keybindings);
        l.setLayoutData((Object)new GridData(3, 1, false, false));
        final TableViewer viewer = new TableViewer(parent);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        viewer.setContentProvider((IContentProvider)cp);
        GridData gd2 = new GridData(1808);
        viewer.getControl().setLayoutData((Object)gd2);
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this.getEditor(), this.Messages));
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS);
        viewer.setInput((Object)prop.observeDetail((IObservableValue)this.getMaster()));
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 3, false, false));
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        Button b2 = new Button(buttonComp, 0x800008);
        b2.setText(this.Messages.ModelTooling_Common_Up);
        b2.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        b2.setLayoutData((Object)new GridData(4, 2, true, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!viewer.getSelection().isEmpty() && (s = (IStructuredSelection)viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MBindingTable container = (MBindingTable)BindingTableEditor.this.getMaster().getValue();
                    int idx = container.getBindings().indexOf(obj) - 1;
                    if (idx >= 0 && (cmd = MoveCommand.create((EditingDomain)BindingTableEditor.this.getEditingDomain(), (Object)BindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS, (Object)obj, (int)idx)).canExecute()) {
                        BindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b2 = new Button(buttonComp, 0x800008);
        b2.setText(this.Messages.ModelTooling_Common_Down);
        b2.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        b2.setLayoutData((Object)new GridData(4, 2, true, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!viewer.getSelection().isEmpty() && (s = (IStructuredSelection)viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MBindingTable container = (MBindingTable)BindingTableEditor.this.getMaster().getValue();
                    int idx = container.getBindings().indexOf(obj) + 1;
                    if (idx < container.getBindings().size() && (cmd = MoveCommand.create((EditingDomain)BindingTableEditor.this.getEditingDomain(), (Object)BindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS, (Object)obj, (int)idx)).canExecute()) {
                        BindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b2 = new Button(buttonComp, 0x800008);
        b2.setText(this.Messages.ModelTooling_Common_AddEllipsis);
        b2.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        b2.setLayoutData((Object)new GridData(4, 2, true, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingTableEditor.this.handleAddKeyBinding();
            }
        });
        b2 = new Button(buttonComp, 0x800008);
        b2.setText(this.Messages.ModelTooling_Common_Remove);
        b2.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        b2.setLayoutData((Object)new GridData(4, 2, true, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!viewer.getSelection().isEmpty()) {
                    List keybinding = ((IStructuredSelection)viewer.getSelection()).toList();
                    Command cmd = RemoveCommand.create((EditingDomain)BindingTableEditor.this.getEditingDomain(), (Object)BindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS, (Collection)keybinding);
                    if (cmd.canExecute()) {
                        BindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MBindingTable.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return this.BINDING_TABLE__BINDINGS.observe(element);
    }

    @Override
    public String getDetailLabel(Object element) {
        MBindingTable cmd = (MBindingTable)element;
        if (cmd.getBindingContext() != null && cmd.getBindingContext().getName() != null && cmd.getBindingContext().getName().trim().length() > 0) {
            return cmd.getBindingContext().getName();
        }
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.BINDING_TABLE__BINDING_CONTEXT, CommandsPackageImpl.Literals.BINDING_CONTEXT__NAME})};
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    protected void handleAddKeyBinding() {
        MKeyBinding handler = MCommandsFactory.INSTANCE.createKeyBinding();
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS, (Object)handler);
        this.setElementId(handler);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(handler);
        }
    }
}

