/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.tools.emf.editor3x.RefactorParticipantDelegate;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class ModelMoveParticipant
extends MoveParticipant {
    private IType _type;
    private IPackageFragment _pckage;
    private IFile _file;
    private IFolder _folder;

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this._type = (IType)element;
            return true;
        }
        if (element instanceof IPackageFragment) {
            this._pckage = (IPackageFragment)element;
            return true;
        }
        if (element instanceof IFile) {
            this._file = (IFile)element;
            return true;
        }
        if (element instanceof IFolder) {
            this._folder = (IFolder)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Workbench Model Contribution Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("Creating Change ..", -1);
        Change change = null;
        if (this._type != null) {
            change = this.createClassChange(pm, this._type);
        } else if (this._pckage != null) {
            change = this.createPackageChange(pm, this._pckage);
        } else if (this._file != null) {
            change = this.createFileChange(pm, this._file);
        }
        pm.done();
        return change;
    }

    private Change createFileChange(IProgressMonitor pm, IFile file) throws CoreException {
        String newUrl = "platform:/plugin/";
        if (this.getArguments().getDestination() instanceof IFolder) {
            IFolder folder = (IFolder)this.getArguments().getDestination();
            newUrl = String.valueOf(newUrl) + folder.getProject().getName() + "/" + folder.getProjectRelativePath().toString() + "/" + file.getName();
        } else {
            IProject project = (IProject)this.getArguments().getDestination();
            newUrl = String.valueOf(newUrl) + project.getName() + "/" + file.getName();
        }
        String oldUrl = "platform:/plugin" + file.getFullPath();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }

    private Change createPackageChange(IProgressMonitor pm, IPackageFragment pckage) throws CoreException, OperationCanceledException {
        String fromBundle = Util.getBundleSymbolicName(pckage.getJavaProject().getProject());
        IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)this.getArguments().getDestination();
        String toBundle = Util.getBundleSymbolicName(fragmentRoot.getJavaProject().getProject());
        String newUrl = "bundleclass://" + toBundle + "/" + pckage.getElementName();
        String oldUrl = "bundleclass://" + fromBundle + "/" + pckage.getElementName();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }

    private Change createClassChange(IProgressMonitor pm, IType type) throws CoreException, OperationCanceledException {
        String fromBundle = Util.getBundleSymbolicName(this._type.getJavaProject().getProject());
        String fromClassname = type.getFullyQualifiedName();
        IPackageFragment fragment = (IPackageFragment)this.getArguments().getDestination();
        String toBundle = Util.getBundleSymbolicName(fragment.getJavaProject().getProject());
        String toClassName = fragment.getElementName().length() == 0 ? type.getElementName() : String.valueOf(fragment.getElementName()) + "." + type.getElementName();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, "bundleclass://" + fromBundle + "/" + fromClassname, "bundleclass://" + toBundle + "/" + toClassName);
    }
}

