/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.context.spy.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.internal.tools.context.spy.search.StringMatcher;

@Creatable
@Singleton
public class ContextRegistry {
    @Inject
    Logger log;
    private StringMatcher matcher;
    private String pattern;
    private boolean ignoreCase;
    private boolean ignoreWildCards;

    public void setPattern(String newPattern) {
        this.pattern = newPattern;
    }

    public void setIgnoreCase(boolean newIgnoreCase) {
        this.ignoreCase = newIgnoreCase;
    }

    public void setIgnoreWildCards(boolean ignoreWildCards) {
        this.ignoreWildCards = ignoreWildCards;
    }

    public boolean containsText(IEclipseContext ctx) {
        if (this.pattern == null) {
            this.pattern = "";
        }
        this.matcher = new StringMatcher(this.pattern, this.ignoreCase, this.ignoreWildCards);
        Collection<String> values = this.computeValues(ctx);
        boolean found = false;
        for (String s : values) {
            if (!this.matchText(s)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean matchText(String text) {
        return this.matcher != null && this.matcher.match(text);
    }

    private Collection<String> computeValues(IEclipseContext ctx) {
        ArrayList<String> result = new ArrayList<String>();
        if (ctx instanceof EclipseContext) {
            EclipseContext currentContext = (EclipseContext)ctx;
            this.extractStringsFromMap(currentContext.localData(), result);
            this.extractStringsFromMap(currentContext.localContextFunction(), result);
            Set localKeys = currentContext.localData().keySet();
            Set localContextFunctionsKeys = currentContext.localContextFunction().keySet();
            if (currentContext.getRawListenerNames() != null) {
                for (String name : currentContext.getRawListenerNames()) {
                    if (localKeys.contains(name) || localContextFunctionsKeys.contains(name)) continue;
                    result.add(name);
                }
            }
        } else {
            this.log.warn("Warning : the received EclipseContext has not the expected type. It is a : " + ctx.getClass().toString());
        }
        return result;
    }

    private void extractStringsFromMap(Map<String, Object> map, Collection<String> result) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.add(entry.getKey().toString());
            Object value = entry.getValue();
            if (value == null) continue;
            result.add(value.toString());
        }
    }
}

