/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetBinding<M, T>
extends Binding<IObservableSet<M>, IObservableSet<T>> {
    private UpdateSetStrategy<T, M> targetToModel;
    private UpdateSetStrategy<M, T> modelToTarget;
    private IObservableValue<IStatus> validationStatusObservable;
    private boolean updatingTarget;
    private boolean updatingModel;
    private ISetChangeListener<T> targetChangeListener = new ISetChangeListener<T>(){

        public void handleSetChange(SetChangeEvent<T> event) {
            if (!SetBinding.this.updatingTarget) {
                SetBinding.this.doUpdate((IObservableSet)SetBinding.this.getTarget(), (IObservableSet)SetBinding.this.getModel(), event.diff, SetBinding.this.targetToModel, false, false);
            }
        }
    };
    private ISetChangeListener<M> modelChangeListener = new ISetChangeListener<M>(){

        public void handleSetChange(SetChangeEvent<M> event) {
            if (!SetBinding.this.updatingModel) {
                SetBinding.this.doUpdate((IObservableSet)SetBinding.this.getModel(), (IObservableSet)SetBinding.this.getTarget(), event.diff, SetBinding.this.modelToTarget, false, false);
            }
        }
    };

    public SetBinding(IObservableSet<T> target, IObservableSet<M> model, UpdateSetStrategy<T, M> targetToModelStrategy, UpdateSetStrategy<M, T> modelToTargetStrategy) {
        super(target, model);
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
        if ((this.targetToModel.getUpdatePolicy() & UpdateSetStrategy.POLICY_UPDATE) != 0) {
            target.addSetChangeListener(this.targetChangeListener);
        } else {
            this.targetChangeListener = null;
        }
        if ((this.modelToTarget.getUpdatePolicy() & UpdateSetStrategy.POLICY_UPDATE) != 0) {
            model.addSetChangeListener(this.modelChangeListener);
        } else {
            this.modelChangeListener = null;
        }
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.updateModelToTarget();
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.validateTargetToModel();
        }
    }

    @Override
    public void updateModelToTarget() {
        final IObservableSet modelSet = (IObservableSet)this.getModel();
        modelSet.getRealm().exec(new Runnable(){

            public void run() {
                SetDiff diff = Diffs.computeSetDiff(Collections.emptySet(), (Set)modelSet);
                SetBinding.this.doUpdate(modelSet, (IObservableSet)SetBinding.this.getTarget(), diff, SetBinding.this.modelToTarget, true, true);
            }
        });
    }

    @Override
    public void updateTargetToModel() {
        final IObservableSet targetSet = (IObservableSet)this.getTarget();
        targetSet.getRealm().exec(new Runnable(){

            public void run() {
                SetDiff diff = Diffs.computeSetDiff(Collections.emptySet(), (Set)targetSet);
                SetBinding.this.doUpdate(targetSet, (IObservableSet)SetBinding.this.getModel(), diff, SetBinding.this.targetToModel, true, true);
            }
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private <S, D> void doUpdate(IObservableSet<S> source, final IObservableSet<D> destination, final SetDiff<? extends S> diff, final UpdateSetStrategy<S, D> updateSetStrategy, boolean explicit, final boolean clearDestination) {
        int policy = updateSetStrategy.getUpdatePolicy();
        if (policy == UpdateSetStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateSetStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        destination.getRealm().exec(new Runnable(){

            public void run() {
                if (destination == SetBinding.this.getTarget()) {
                    SetBinding.this.updatingTarget = true;
                } else {
                    SetBinding.this.updatingModel = true;
                }
                BindingStatus multiStatus = BindingStatus.ok();
                try {
                    IStatus setterStatus;
                    if (clearDestination) {
                        destination.clear();
                    }
                    Iterator iterator = diff.getRemovals().iterator();
                    while (iterator.hasNext()) {
                        setterStatus = updateSetStrategy.doRemove(destination, updateSetStrategy.convert(iterator.next()));
                        SetBinding.this.mergeStatus(multiStatus, setterStatus);
                    }
                    iterator = diff.getAdditions().iterator();
                    while (iterator.hasNext()) {
                        setterStatus = updateSetStrategy.doAdd(destination, updateSetStrategy.convert(iterator.next()));
                        SetBinding.this.mergeStatus(multiStatus, setterStatus);
                    }
                }
                finally {
                    SetBinding.this.validationStatusObservable.setValue((Object)multiStatus);
                    if (destination == SetBinding.this.getTarget()) {
                        SetBinding.this.updatingTarget = false;
                    } else {
                        SetBinding.this.updatingModel = false;
                    }
                }
            }
        });
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            ((IObservableSet)this.getTarget()).removeSetChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            ((IObservableSet)this.getModel()).removeSetChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

