/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import org.eclipse.core.databinding.observable.AbstractChangeEvent;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeSupport {
    protected ListenerList<IChangeListener> genericListenerList = null;
    protected ListenerList<IStaleListener> staleListenerList = null;
    protected ListenerList<IDisposeListener> disposeListenerList = null;

    public ChangeSupport(Realm realm) {
        this();
    }

    public ChangeSupport() {
    }

    public void addListener(Object listenerType, IObservablesListener<?> listener) {
        if (listenerType == AbstractChangeEvent.TYPE) {
            this.addChangeListener((IChangeListener)listener);
        } else if (listenerType == StaleEvent.TYPE) {
            this.addStaleListener((IStaleListener)listener);
        } else if (listenerType == DisposeEvent.TYPE) {
            this.addDisposeListener((IDisposeListener)listener);
        }
    }

    public void removeListener(Object listenerType, IObservablesListener<?> listener) {
        if (listenerType == AbstractChangeEvent.TYPE) {
            this.removeChangeListener((IChangeListener)listener);
        } else if (listenerType == StaleEvent.TYPE) {
            this.removeStaleListener((IStaleListener)listener);
        } else if (listenerType == DisposeEvent.TYPE) {
            this.removeDisposeListener((IDisposeListener)listener);
        }
    }

    public <EV extends ObservableEvent<EV, L>, L extends IObservablesListener<L>> void fireEvent(ObservableEvent<EV, L> event) {
        if (event.getListenerType() == AbstractChangeEvent.TYPE) {
            if (this.genericListenerList != null) {
                this.genericListenerList.fireEvent(event);
            }
        } else if (event.getListenerType() == StaleEvent.TYPE) {
            if (this.staleListenerList != null) {
                this.staleListenerList.fireEvent(event);
            }
        } else if (event.getListenerType() == DisposeEvent.TYPE) {
            if (this.disposeListenerList != null) {
                this.disposeListenerList.fireEvent(event);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void addChangeListener(IChangeListener listener) {
        this.addListener(this.getGenericListenerList(), listener);
    }

    public synchronized void removeChangeListener(IChangeListener listener) {
        if (this.genericListenerList != null) {
            this.removeListener(this.genericListenerList, listener);
        }
    }

    public synchronized void addStaleListener(IStaleListener listener) {
        this.addListener(this.getStaleListenerList(), listener);
    }

    public synchronized void removeStaleListener(IStaleListener listener) {
        if (this.staleListenerList != null) {
            this.removeListener(this.staleListenerList, listener);
        }
    }

    public synchronized void addDisposeListener(IDisposeListener listener) {
        this.getDisposeListenerList().add(listener);
    }

    public synchronized void removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListenerList != null) {
            this.disposeListenerList.remove(listener);
        }
    }

    private ListenerList<IChangeListener> getGenericListenerList() {
        if (this.genericListenerList == null) {
            this.genericListenerList = new ListenerList();
        }
        return this.genericListenerList;
    }

    private ListenerList<IStaleListener> getStaleListenerList() {
        if (this.staleListenerList == null) {
            this.staleListenerList = new ListenerList();
        }
        return this.staleListenerList;
    }

    private ListenerList<IDisposeListener> getDisposeListenerList() {
        if (this.disposeListenerList == null) {
            this.disposeListenerList = new ListenerList();
        }
        return this.disposeListenerList;
    }

    public void fireDispose(DisposeEvent disposeEvent) {
        if (this.disposeListenerList != null) {
            this.disposeListenerList.fireEvent(disposeEvent);
        }
    }

    protected <EV extends ObservableEvent<EV, L>, L extends IObservablesListener<L>> void addListener(ListenerList<L> listenerList, L listener) {
        boolean hadListeners = this.hasListeners();
        listenerList.add(listener);
        if (!hadListeners && this.hasListeners()) {
            this.firstListenerAdded();
        }
    }

    protected <EV extends ObservableEvent<EV, L>, L extends IObservablesListener<L>> void removeListener(ListenerList<L> listenerList, L listener) {
        boolean hadListeners = this.hasListeners();
        listenerList.remove(listener);
        if (hadListeners && !this.hasListeners()) {
            this.lastListenerRemoved();
        }
    }

    protected boolean hasListeners() {
        return this.genericListenerList != null && this.genericListenerList.hasListeners() || this.staleListenerList != null && this.staleListenerList.hasListeners();
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }
}

