/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedSet<E>
implements Set<E> {
    final Set<?> wrappedSet;
    final Class<E> elementType;

    TypedSet(Set<?> wrappedSet, Class<E> elementType) {
        this.wrappedSet = wrappedSet;
        this.elementType = elementType;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedSet.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<?> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                Object next = wrappedIterator.next();
                return TypedSet.this.elementType.cast(next);
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E2[])new Object[this.wrappedSet.size()]);
    }

    @Override
    public <E2> E2[] toArray(E2[] a) {
        int size = this.wrappedSet.size();
        Class<E2> componentType = Util.getComponentType(a);
        E2[] result = a;
        if (a.length < size) {
            result = Util.createArrayInstance(componentType, size);
        }
        int i = 0;
        for (Object element : this.wrappedSet) {
            result[i] = componentType.cast(element);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        return this.size() == that.size() && this.containsAll(that);
    }

    @Override
    public int hashCode() {
        return this.wrappedSet.hashCode();
    }
}

