/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.internal.resources.semantic.ui.BrowseSFSDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class SemanticFileSystemContributor
extends FileSystemContributor {
    public URI getURI(String aString) {
        try {
            String string;
            if (aString.startsWith("semanticfs")) {
                string = aString.substring("semanticfs".length()).replace('\\', '/');
                if (string.charAt(0) == ':') {
                    string = string.substring(1);
                }
            } else {
                string = aString.replace('\\', '/');
            }
            if (string.equals("")) {
                return new URI("semanticfs:/");
            }
            if (string.charAt(0) == '/') {
                return new URI("semanticfs:" + string);
            }
            return new URI("semanticfs:/" + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI browseFileSystem(String initialPath, Shell shell) {
        if (shell == null) {
            Shell newShell = new Shell(Display.getCurrent());
            BrowseSFSDialog dialog = new BrowseSFSDialog(newShell, initialPath);
            dialog.setBlockOnOpen(false);
            dialog.open();
            dialog.close();
            try {
                return new URI(dialog.getSelectedPathString());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        BrowseSFSDialog dialog = new BrowseSFSDialog(shell, initialPath);
        if (dialog.open() == 0) {
            try {
                return new URI(dialog.getSelectedPathString());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }
}

