/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.dnd;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.platform.discovery.core.internal.IContextStructuredSelection;
import org.eclipse.platform.discovery.util.internal.CharsetUtils;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class LocalContextSelectionTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "local-context-selection-transfer-format" + new Long(System.currentTimeMillis()).toString();
    private static final int TYPEID = LocalContextSelectionTransfer.registerType((String)TYPE_NAME);
    private static final LocalContextSelectionTransfer INSTANCE = new LocalContextSelectionTransfer();
    private IContextStructuredSelection selection;
    private long selectionSetTime;

    protected LocalContextSelectionTransfer() {
    }

    public static LocalContextSelectionTransfer getTransfer() {
        return INSTANCE;
    }

    public IContextStructuredSelection getSelection() {
        return this.selection;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result, CharsetUtils.getUTF_8()));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] check = TYPE_NAME.getBytes(CharsetUtils.getUTF_8());
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, JFaceResources.getString((String)"LocalContextSelectionTransfer.errorMessage"), null));
        }
        return this.selection;
    }

    public void setSelection(IContextStructuredSelection s) {
        this.selection = s;
    }

    public long getSelectionSetTime() {
        return this.selectionSetTime;
    }

    public void setSelectionSetTime(long time) {
        this.selectionSetTime = time;
    }
}

