/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal;

import org.eclipse.platform.discovery.ui.internal.SlidingCompositeStatePainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VerticalStatePainter
extends SlidingCompositeStatePainter {
    public VerticalStatePainter(FormToolkit formToolkit) {
        super(formToolkit);
    }

    @Override
    public int[] getArrowDownPolygon(Rectangle clientArea) {
        int topAngleX = this.getTopAngleX(clientArea);
        int topAngleY = this.getTopAngleY(clientArea) - 5;
        int leftAngleX = this.getLeftAngleX(topAngleX);
        int botomY = this.getBottomY(topAngleY);
        int rightAngleX = this.getRightAngleX(topAngleX);
        int[] arrowDown = new int[]{leftAngleX, topAngleY, rightAngleX, topAngleY, topAngleX, botomY};
        return arrowDown;
    }

    private int getBottomY(int topAngleY) {
        return topAngleY + 5;
    }

    private int getLeftAngleX(int topAngleX) {
        return topAngleX - 5;
    }

    private int getTopAngleY(Rectangle clientArea) {
        return clientArea.y + clientArea.height / 2;
    }

    private int getTopAngleX(Rectangle clientArea) {
        return clientArea.width / 2;
    }

    @Override
    public int[] getArrowUpPolygon(Rectangle clientArea) {
        int topAngleX = this.getTopAngleX(clientArea);
        int topAngleY = this.getTopAngleY(clientArea);
        int leftAngleX = this.getLeftAngleX(topAngleX);
        int botomY = this.getBottomY(topAngleY);
        int rightAngleX = this.getRightAngleX(topAngleX);
        int[] arrowUp = new int[]{topAngleX, topAngleY, leftAngleX, botomY, rightAngleX, botomY};
        return arrowUp;
    }

    private int getRightAngleX(int topAngleX) {
        return topAngleX + 5;
    }

    @Override
    public void printSliderButtonDown(PaintEvent e, Rectangle clientArea) {
        int X_COORD = this.getHorizontalBeginPosition(clientArea);
        int Y_COORD = this.getVerticalBeginPosition(clientArea);
        int HEIGHT = this.getVerticalSize(clientArea);
        int WIDTH = this.getHorizontalSize(clientArea);
        int HALF_HEIGHT = HEIGHT / 2;
        int HALF_WIDTH = WIDTH / 2;
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.drawRoundRectangle(X_COORD, Y_COORD, WIDTH - 1, HALF_HEIGHT, 6, 6);
        e.gc.drawRoundRectangle(HALF_WIDTH - X_COORD - 15, Y_COORD, 30, HEIGHT - 5, 10, 10);
        e.gc.setBackground(this.getSliderFillColor());
        e.gc.fillRoundRectangle(X_COORD + 1 + 2, Y_COORD + 1, WIDTH - 2 - 4, HALF_HEIGHT - 3, 6, 6);
        e.gc.fillRectangle(X_COORD + 1 + 2, Y_COORD + 1, WIDTH - 2 - 4, HALF_HEIGHT - 2 - 4);
        e.gc.fillRoundRectangle(HALF_WIDTH - X_COORD - 15 + 1 + 2, Y_COORD + 1, 25, HEIGHT - 8, 4, 4);
        e.gc.setForeground(this.getUnderBorderColor());
        e.gc.setLineWidth(2);
        e.gc.drawLine(X_COORD + 1 + 2, HALF_HEIGHT + 1 - 2, HALF_WIDTH - X_COORD - 15 + 1 + 2, HALF_HEIGHT + 1 - 2);
        e.gc.drawLine(HALF_WIDTH + 15, HALF_HEIGHT + 1 - 2, WIDTH - 1 - 2, HALF_HEIGHT + 1 - 2);
        e.gc.drawLine(HALF_WIDTH - X_COORD - 15 + 2, Y_COORD + HALF_HEIGHT, HALF_WIDTH - X_COORD - 15 + 2, Y_COORD + HALF_HEIGHT + 1);
        e.gc.drawLine(HALF_WIDTH + 15 - 1, Y_COORD + HALF_HEIGHT, HALF_WIDTH + 15 - 1, Y_COORD + HALF_HEIGHT + 1);
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.setLineWidth(1);
        e.gc.setBackground(this.getTriangleColor());
        e.gc.drawLine(X_COORD, Y_COORD, X_COORD + WIDTH, Y_COORD);
        e.gc.fillPolygon(this.getArrowDownPolygon(clientArea));
    }

    @Override
    public void printSliderButtonUp(PaintEvent e, Rectangle clientArea) {
        int X_COORD = this.getHorizontalBeginPosition(clientArea);
        int Y_COORD = this.getVerticalBeginPosition(clientArea);
        int HEIGHT = this.getVerticalSize(clientArea);
        int WIDTH = this.getHorizontalSize(clientArea);
        int HALF_HEIGHT = HEIGHT / 2;
        int HALF_WIDTH = WIDTH / 2;
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.drawRoundRectangle(X_COORD, HALF_HEIGHT, WIDTH - 1, HALF_HEIGHT, 6, 6);
        e.gc.drawRoundRectangle(HALF_WIDTH - X_COORD - 15, Y_COORD + 5, 30, HEIGHT - 5, 10, 10);
        e.gc.setBackground(this.getSliderFillColor());
        e.gc.fillRoundRectangle(X_COORD + 1 + 2, Y_COORD + HALF_HEIGHT + 1 + 2, WIDTH - 2 - 4, HALF_HEIGHT - 2 - 2, 6, 6);
        e.gc.fillRectangle(X_COORD + 1 + 2, Y_COORD + HALF_HEIGHT + 1 + 4, WIDTH - 2 - 4, HALF_HEIGHT - 2 - 4);
        e.gc.fillRoundRectangle(HALF_WIDTH - X_COORD - 15 + 1 + 2, Y_COORD + 5 + 1 + 2, 25, HEIGHT - 5, 4, 4);
        e.gc.setForeground(this.getUnderBorderColor());
        e.gc.setLineWidth(2);
        e.gc.drawLine(X_COORD + 1 + 2, Y_COORD + HALF_HEIGHT + 2, HALF_WIDTH - X_COORD - 15 + 1 + 2, Y_COORD + HALF_HEIGHT + 2);
        e.gc.drawLine(HALF_WIDTH + 15, Y_COORD + HALF_HEIGHT + 2, WIDTH - 1 - 2, Y_COORD + HALF_HEIGHT + 2);
        e.gc.drawLine(HALF_WIDTH - X_COORD - 15 + 2, Y_COORD + HALF_HEIGHT, HALF_WIDTH - X_COORD - 15 + 2, Y_COORD + HALF_HEIGHT + 1);
        e.gc.drawLine(HALF_WIDTH + 15 - 1, Y_COORD + HALF_HEIGHT, HALF_WIDTH + 15 - 1, Y_COORD + HALF_HEIGHT + 1);
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.setLineWidth(1);
        e.gc.setBackground(this.getTriangleColor());
        e.gc.drawLine(X_COORD, Y_COORD + HEIGHT - 1, X_COORD + WIDTH, Y_COORD + HEIGHT - 1);
        e.gc.fillPolygon(this.getArrowUpPolygon(clientArea));
    }

    @Override
    public void arrangeControls(FormData hideButtonFormData, FormData sashFormData, FormData upperScrolledCompositeFormData, FormData bottomCompositeFormData, int targetPosition, int buttonHeight) {
        hideButtonFormData.bottom = new FormAttachment(0, targetPosition);
        hideButtonFormData.top = new FormAttachment(0, targetPosition - buttonHeight);
        sashFormData.top = hideButtonFormData.bottom;
        sashFormData.bottom = new FormAttachment(0, targetPosition + 2);
        upperScrolledCompositeFormData.bottom = hideButtonFormData.top;
        bottomCompositeFormData.top = sashFormData.bottom;
    }

    @Override
    public void arrangeControlsOnUpperVisibilityOff(FormData hideButtonFormData, FormData bottomCompositeFormData, int buttonHeight) {
        hideButtonFormData.top = new FormAttachment(0, 0);
        bottomCompositeFormData.top = hideButtonFormData.bottom = new FormAttachment(0, buttonHeight);
    }

    @Override
    public void adjustControlsLayoutData(FormData upperScrolledCompositeData, FormData hideButtonData, FormData sashData, FormData bottomCompositeData, Canvas hideButton, int buttonHeight) {
        upperScrolledCompositeData.bottom = new FormAttachment((Control)hideButton);
        hideButtonData.height = buttonHeight;
        sashData.height = 2;
    }
}

