/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SlidingCompositeStatePainter {
    protected static final int TRIANGLE_SIDE = 10;
    protected static final int TRIANGLE_HEIGHT = 5;
    protected static final int IDENTATION = 5;
    protected static final int ARC_BIG = 10;
    protected static final int ARC_MEDIUM = 6;
    protected static final int ARC_SMALL = 4;
    protected static final int ONE_PIXEL = 1;
    protected static final int TOP_RECTANGLE_WIDTH = 30;
    protected static final int WHITE_LINE_WIDTH = 2;
    protected static final String COLOR_WHITE = "WHITE";
    protected static final String BLUE_FILL = "BLUE_FILL";
    protected static final String BLUE_BORDER = "BLUE_BORDER";
    protected static final String COLOR_BLACK = "BLACK";
    protected final int SASH_HEIGHT = 2;
    protected int targetPosition = 0;
    protected FormToolkit formToolkit;

    public SlidingCompositeStatePainter(FormToolkit formToolkit) {
        this.formToolkit = formToolkit;
    }

    public abstract void arrangeControls(FormData var1, FormData var2, FormData var3, FormData var4, int var5, int var6);

    public abstract void printSliderButtonDown(PaintEvent var1, Rectangle var2);

    public abstract void printSliderButtonUp(PaintEvent var1, Rectangle var2);

    abstract int[] getArrowUpPolygon(Rectangle var1);

    abstract int[] getArrowDownPolygon(Rectangle var1);

    public abstract void arrangeControlsOnUpperVisibilityOff(FormData var1, FormData var2, int var3);

    public abstract void adjustControlsLayoutData(FormData var1, FormData var2, FormData var3, FormData var4, Canvas var5, int var6);

    protected int getHorizontalSize(Rectangle clientArea) {
        return clientArea.width;
    }

    protected int getVerticalSize(Rectangle clientArea) {
        return clientArea.height;
    }

    protected int getVerticalBeginPosition(Rectangle clientArea) {
        return clientArea.y;
    }

    protected int getHorizontalBeginPosition(Rectangle clientArea) {
        return clientArea.x;
    }

    protected Color getTriangleColor() {
        return this.getColourById(COLOR_BLACK, new RGB(0, 0, 0));
    }

    protected Color getSliderFillColor() {
        return this.getColourById(BLUE_FILL, new RGB(234, 237, 243));
    }

    protected Color getSliderBorderColor() {
        return this.getColourById(BLUE_BORDER, new RGB(181, 189, 210));
    }

    protected Color getUnderBorderColor() {
        return this.getColourById(COLOR_WHITE, new RGB(255, 255, 255));
    }

    private Color getColourById(String key, RGB colourRgb) {
        Color existingColour = this.formToolkit.getColors().getColor(key);
        return existingColour == null ? this.formToolkit.getColors().createColor(key, colourRgb) : existingColour;
    }
}

