/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.TextControlPageObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextControlTest {
    private TextControlPageObject textControl;

    @Before
    public void setUp() {
        this.textControl = new TextControlPageObject();
        this.textControl.open();
    }

    @After
    public void tearDown() {
        this.textControl.close();
    }

    @Test
    public void testTextIsRestoredWhenControlIsEnabled() {
        this.textControl.enterText("12345_6789");
        Assert.assertEquals((String)"Unexpected text value", (Object)"12345_6789", (Object)this.textControl.get());
        Assert.assertEquals((String)"Unexpected text in SWT text", (Object)"12345_6789", (Object)this.textControl.getDisplayedText());
        this.textControl.setEnabled(false);
        Assert.assertEquals((String)"SWT text should be empty", (Object)"", (Object)this.textControl.getDisplayedText());
        Assert.assertEquals((String)"Unexpected text value", (Object)"", (Object)this.textControl.get());
        this.textControl.setEnabled(true);
        Assert.assertEquals((String)"Unexpected text value", (Object)"12345_6789", (Object)this.textControl.get());
        Assert.assertEquals((String)"Unexpected text in SWT text", (Object)"12345_6789", (Object)this.textControl.getDisplayedText());
    }

    @Test
    public void testTextMessageAmongEnabledStates() {
        this.textControl.setMessage("MyMessage");
        this.textControl.focus();
        Assert.assertEquals((String)"Unexpected message", (Object)"MyMessage", (Object)this.textControl.getMessage());
        Assert.assertEquals((String)"Unexpected text displayed", (Object)"", (Object)this.textControl.getDisplayedText());
        this.textControl.setEnabled(false);
        Assert.assertEquals((String)"Unexpected message", (Object)"", (Object)this.textControl.getMessage());
        Assert.assertEquals((String)"Unexpected text displayed", (Object)"MyMessage", (Object)this.textControl.getDisplayedText());
        this.textControl.setEnabled(true);
        Assert.assertEquals((String)"Unexpected message", (Object)"MyMessage", (Object)this.textControl.getMessage());
        Assert.assertEquals((String)"Unexpected text displayed", (Object)"", (Object)this.textControl.getDisplayedText());
    }
}

