/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.search.activation;

import java.text.MessageFormat;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;

public class SearchProviderActivationConfigDummy
implements ISearchProviderActivationConfig {
    private ISearchProvidersExtensionParser searchProvidersExtensionParser;

    public SearchProviderActivationConfigDummy(ISearchProvidersExtensionParser parser) {
        this.searchProvidersExtensionParser = parser;
    }

    @Override
    public ISearchProviderDescription getActiveSearchProviderDescription(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory) throws ProviderNotFoundException {
        for (ISearchProviderDescription searchProvider : this.searchProvidersExtensionParser.readContributions()) {
            if (!searchProvider.getObjectType().getId().equals(objectType.getId())) continue;
            for (IDestinationCategoryDescription supportedCategory : searchProvider.getSupportedDestinationCategories()) {
                if (!supportedCategory.getId().equals(destinationCategory.getId())) continue;
                return searchProvider;
            }
        }
        throw new ProviderNotFoundException("No provider found for object id " + objectType.getId() + " and category id " + destinationCategory.getId());
    }

    @Override
    public ISearchProviderDescription getActiveSearchProviderDescription(IObjectTypeDescription objectType) throws ProviderNotFoundException {
        for (ISearchProviderDescription searchProvider : this.searchProvidersExtensionParser.readContributions()) {
            if (!searchProvider.getObjectType().getId().equals(objectType.getId()) || !searchProvider.getSupportedDestinationCategories().isEmpty()) continue;
            return searchProvider;
        }
        throw new ProviderNotFoundException(MessageFormat.format("No provider found for object id {0} that supports no categories", objectType.getId()));
    }
}

