/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.testutils.utils.testcases.EqualsTestCase;
import org.mockito.Mockito;

public class DestinationItemPairTest
extends EqualsTestCase<DestinationItemPair> {
    private ISearchDestination destination;
    private ISearchDestination destination2;
    private Object item;
    private Object item2;
    private DestinationItemPair pair;
    private DestinationItemPair pair2;

    public DestinationItemPairTest() {
        super("DestinationItemPairTest", DestinationItemPair.class);
    }

    protected void setUp() throws Exception {
        this.destination = (ISearchDestination)Mockito.mock(ISearchDestination.class);
        this.destination2 = (ISearchDestination)Mockito.mock(ISearchDestination.class);
        this.item = new Object();
        this.item2 = new Object();
        this.pair = new DestinationItemPair(this.destination, this.item);
        this.pair2 = new DestinationItemPair(this.destination2, this.item2);
    }

    public void testGetters() {
        DestinationItemPairTest.assertSame((String)"unexpected item returned", (Object)this.item, (Object)this.pair.getItem());
        DestinationItemPairTest.assertSame((String)"unexpected destination returned", (Object)this.destination, (Object)this.pair.getDestination());
    }

    public void pairEqualsWithObject(Object obj, boolean isEqual) {
        DestinationItemPairTest.assertEquals((boolean)isEqual, (boolean)this.pair.equals(obj));
    }

    public void testEqualsWithObject() {
        this.pairEqualsWithObject(new Object(), false);
    }

    public void testEqualsWithNull() {
        this.pairEqualsWithObject(null, false);
    }

    public void testEqualsWithSameDestinations() {
        DestinationItemPair pair1 = new DestinationItemPair(this.destination, new Object());
        this.pairEqualsWithObject(pair1, false);
    }

    public void testEqualsWithSameItems() {
        ISearchDestination destination1 = (ISearchDestination)Mockito.mock(ISearchDestination.class);
        DestinationItemPair pair1 = new DestinationItemPair(destination1, this.item);
        this.pairEqualsWithObject(pair1, false);
    }

    public void testEqualsSame() {
        DestinationItemPair pair1 = new DestinationItemPair(this.destination, this.item);
        this.pairEqualsWithObject(pair1, true);
    }

    public void testEquals() {
        this.pairEqualsWithObject(this.pair, true);
    }

    public DestinationItemPairTest(Class<DestinationItemPair> testClass) {
        super(testClass);
    }

    public DestinationItemPair newAncestorEqualInstance() {
        return new DestinationItemPair(this.destination, this.item){};
    }

    public DestinationItemPair newEqualInstance() {
        return this.pair;
    }

    public DestinationItemPair newNonEqualInstance() {
        return this.pair2;
    }

    public Iterator<DestinationItemPair> newObjectIterator(int iterations) {
        ArrayList<DestinationItemPair> list = new ArrayList<DestinationItemPair>(iterations);
        int i = 0;
        while (i < iterations) {
            list.add(new DestinationItemPair(this.destination, this.item));
            ++i;
        }
        return list.iterator();
    }

    public void modifyObjectInstance(DestinationItemPair instance) {
    }
}

