/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.SearchEvent;
import org.eclipse.platform.discovery.core.test.unit.internal.SearchConsoleControllerFixture;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchQuery;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.jmock.core.Constraint;
import org.jmock.core.constraint.IsSame;

public class SearchConsoleControllerTest
extends SearchConsoleControllerFixture {
    private static final String searchTitle = "testSearchTitle";
    private static final String searchDescription = "testSearchDescription";

    public void testDestinationsChangeOnObjectSelectionChange() {
        this.view.expects(this.once()).method("showDestinationsCategories").with((Constraint)new IsSame((Object)this.destinationCategories_obj1));
        this.testController.objectTypeSelected(this.objectType_1);
        this.view.verify();
        this.view.expects(this.once()).method("showDestinationsCategories").with((Constraint)new IsSame((Object)this.destinationCategories_obj2));
        this.testController.objectTypeSelected(this.objectType_2);
        this.view.verify();
    }

    public void testDefaultSearchInvoked() throws ProviderNotFoundException, SearchFailedException {
        this.sessionManager.stubs().method("session").with((Constraint)this.eq("defaultSessionId"), (Constraint)this.eq(1)).will(this.returnValue(this.testSession.proxy()));
        this.sessionHistory.stubs().method("historyLimit").will(this.returnValue(1));
        this.searchInvokedTest("defaultSessionId", 1);
    }

    public void testNonDefaultSearchInvoked() throws ProviderNotFoundException, SearchFailedException {
        this.sessionManager.stubs().method("session").with((Constraint)this.eq("searchSessionId"), (Constraint)this.eq(5)).will(this.returnValue(this.testSession.proxy()));
        this.sessionHistory.stubs().method("historyLimit").will(this.returnValue(5));
        this.searchInvokedTest("searchSessionId", 5);
    }

    private void searchInvokedTest(String sessionId, int expectedHistrorySize) throws ProviderNotFoundException, SearchFailedException {
        Mock searchQuery = this.mock(ISearchQuery.class);
        Mock searchProvider = this.mock(ISearchProvider.class);
        this.searchProviderDescr_1.expects(this.once()).method("createInstance").will(this.returnValue(searchProvider.proxy()));
        Mock searchDestination = this.mock(ISearchDestination.class);
        this.providerConfig.stubs().method("getActiveSearchProvider").with((Constraint)this.same(this.objectType_1), (Constraint)this.same(this.destinationCategory1)).will(this.returnValue(this.searchProviderDescr_1.proxy()));
        this.providerConfig.stubs().method("getDestinationCategoriesForDestination").with((Constraint)this.eq(searchDestination.proxy())).will(this.returnValue(Arrays.asList(this.destinationCategory1)));
        Mock subdestination = this.mock(ISearchSubdestination.class);
        ArrayList<ISearchSubdestination> subdestinations = new ArrayList<ISearchSubdestination>();
        subdestinations.add((ISearchSubdestination)subdestination.proxy());
        this.providerConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory1), (Constraint)this.eq(this.searchProviderDescr_1.proxy())).will(this.returnValue(subdestinations));
        this.providerConfig.stubs().method("isSubdestinationActive").with((Constraint)this.eq(subdestination.proxy()), (Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory1), (Constraint)this.eq(this.searchProviderDescr_1.proxy())).will(this.returnValue(true));
        Mock searchParameters = this.mock(ISearchParameters.class);
        searchProvider.expects(this.once()).method("createQuery").with((Constraint)this.eq(searchParameters.proxy())).will(this.returnValue(searchQuery.proxy()));
        final Object searchResult = new Object();
        searchQuery.expects(this.once()).method("execute").with((Constraint)this.eq(this.operationRunner.proxy())).will(this.returnValue(searchResult));
        final ISearchContext[] shownSearchContext = new ISearchContext[1];
        this.view.expects(this.once()).method("showResult").with(new Constraint(){

            public boolean eval(Object arg0) {
                shownSearchContext[0] = (ISearchContext)arg0;
                return shownSearchContext[0].searchResult() == searchResult;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        searchParameters.stubs().method("getObjectTypeId").will(this.returnValue(this.objectType_1.getId()));
        searchParameters.stubs().method("getSearchDestination").will(this.returnValue(searchDestination.proxy()));
        this.sessionHistory.expects(this.once()).method("track").with((Constraint)this.isA(ISearchContext.class));
        SearchEvent event = new SearchEvent((ISearchParameters)searchParameters.proxy(), sessionId, searchTitle, searchDescription);
        this.testController.search(event);
        SearchConsoleControllerTest.assertSame((String)"The returned context was not contained by session that the search was performed in", (Object)this.testSession.proxy(), (Object)shownSearchContext[0].session());
        int historyLimit = shownSearchContext[0].session().historyTrack().historyLimit();
        SearchConsoleControllerTest.assertEquals((String)"Unexpected history limit", (int)historyLimit, (int)shownSearchContext[0].session().historyTrack().historyLimit());
    }

    public void testDestinationsChanged() {
        this.view.expects(this.once()).method("updateDestinationsSelector");
        this.testController.searchDestinationsChanged();
    }

    public void testDestinationSelectedChanged() {
        final GroupingHierarchy group = new GroupingHierarchy("A", (Object)"a");
        HashSet<GroupingHierarchy> groupings = new HashSet<GroupingHierarchy>(Arrays.asList(group));
        Mock searchProvider = this.mock(ISearchProvider.class);
        searchProvider.expects(this.once()).method("getGroupingHierarchies").will(this.returnValue(groupings));
        this.searchProviderDescr_1.expects(this.once()).method("createInstance").will(this.returnValue(searchProvider.proxy()));
        Mock searchDestination = this.mock(ISearchDestination.class);
        this.providerConfig.stubs().method("getActiveSearchProvider").with((Constraint)this.same(this.objectType_1), (Constraint)this.same(this.destinationCategory1)).will(this.returnValue(this.searchProviderDescr_1.proxy()));
        this.providerConfig.stubs().method("getDestinationCategoriesForDestination").with((Constraint)this.eq(searchDestination.proxy())).will(this.returnValue(Arrays.asList(this.destinationCategory1)));
        this.providerConfig.stubs().method("getAvailableSearchSubdestinations").will(this.returnValue(new ArrayList()));
        this.view.expects(this.once()).method("showGroupingHierarchies").with(new Constraint(){

            public boolean eval(Object arg0) {
                if (!(arg0 instanceof List)) {
                    return false;
                }
                return ((List)arg0).iterator().next() == group;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        this.testController.searchDestinationSelected(this.objectType_1, (ISearchDestination)searchDestination.proxy());
    }

    public void testDestinationsDeselected() {
        this.view.expects(this.once()).method("showGroupingHierarchies").with(new Constraint(){

            public boolean eval(Object arg0) {
                if (!(arg0 instanceof List)) {
                    return false;
                }
                return ((List)arg0).size() == 0;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        this.testController.searchDestinationSelected(this.objectType_1, null);
    }

    public void testSubdestinationActivationChanged() {
        final GroupingHierarchy group = new GroupingHierarchy("A", (Object)"a");
        HashSet<GroupingHierarchy> groupings = new HashSet<GroupingHierarchy>(Arrays.asList(group));
        Mock searchProvider = this.mock(ISearchProvider.class);
        searchProvider.expects(this.once()).method("getGroupingHierarchies").will(this.returnValue(groupings));
        this.searchProviderDescr_1.expects(this.once()).method("createInstance").will(this.returnValue(searchProvider.proxy()));
        Mock searchDestination = this.mock(ISearchDestination.class);
        this.providerConfig.stubs().method("getActiveSearchProvider").with((Constraint)this.same(this.objectType_1), (Constraint)this.same(this.destinationCategory1)).will(this.returnValue(this.searchProviderDescr_1.proxy()));
        this.providerConfig.stubs().method("getDestinationCategoriesForDestination").with((Constraint)this.eq(searchDestination.proxy())).will(this.returnValue(Arrays.asList(this.destinationCategory1)));
        this.providerConfig.stubs().method("getAvailableSearchSubdestinations").will(this.returnValue(new ArrayList()));
        this.view.expects(this.once()).method("showGroupingHierarchies").with(new Constraint(){

            public boolean eval(Object arg0) {
                if (!(arg0 instanceof List)) {
                    return false;
                }
                return ((List)arg0).iterator().next() == group;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        this.testController.subdestinationActivationChanged(this.objectType_1, (ISearchDestination)searchDestination.proxy(), null, false);
    }
}

