/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.ChangeSupport;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObservableMap<K, V>
extends AbstractMap<K, V>
implements IObservableMap<K, V> {
    private final Realm realm;
    private PrivateChangeSupport changeSupport;
    private volatile boolean disposed = false;
    private boolean stale;

    public AbstractObservableMap() {
        this(Realm.getDefault());
    }

    protected void lastListenerRemoved() {
    }

    protected void firstListenerAdded() {
    }

    public AbstractObservableMap(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        ObservableTracker.observableCreated(this);
        this.realm = realm;
        this.changeSupport = new PrivateChangeSupport(realm);
    }

    @Override
    public synchronized void addMapChangeListener(IMapChangeListener<K, V> listener) {
        if (!this.disposed) {
            this.changeSupport.addListener(MapChangeEvent.TYPE, listener);
        }
    }

    @Override
    public synchronized void removeMapChangeListener(IMapChangeListener<K, V> listener) {
        if (!this.disposed) {
            this.changeSupport.removeListener(MapChangeEvent.TYPE, listener);
        }
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        if (!this.disposed) {
            this.changeSupport.addChangeListener(listener);
        }
    }

    @Override
    public synchronized void addStaleListener(IStaleListener listener) {
        if (!this.disposed) {
            this.changeSupport.addStaleListener(listener);
        }
    }

    protected synchronized boolean hasListeners() {
        return !this.disposed && this.changeSupport.hasListeners();
    }

    @Override
    public synchronized void addDisposeListener(IDisposeListener listener) {
        if (!this.disposed) {
            this.changeSupport.addDisposeListener(listener);
        }
    }

    @Override
    public synchronized void removeDisposeListener(IDisposeListener listener) {
        if (!this.disposed) {
            this.changeSupport.removeDisposeListener(listener);
        }
    }

    @Override
    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.changeSupport.fireEvent(new DisposeEvent(this));
            this.changeSupport.dispose();
            this.changeSupport = null;
        }
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public boolean isStale() {
        this.checkRealm();
        return this.stale;
    }

    @Override
    public Object getKeyType() {
        return null;
    }

    @Override
    public Object getValueType() {
        return null;
    }

    @Override
    public synchronized void removeChangeListener(IChangeListener listener) {
        if (!this.disposed) {
            this.changeSupport.removeChangeListener(listener);
        }
    }

    @Override
    public synchronized void removeStaleListener(IStaleListener listener) {
        if (!this.disposed) {
            this.changeSupport.removeStaleListener(listener);
        }
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        this.stale = stale;
        if (stale) {
            this.fireStale();
        }
    }

    protected void fireStale() {
        this.checkRealm();
        this.changeSupport.fireEvent(new StaleEvent(this));
    }

    protected void fireChange() {
        this.checkRealm();
        this.changeSupport.fireEvent(new ChangeEvent(this));
    }

    protected void fireMapChange(MapDiff<K, V> diff) {
        this.checkRealm();
        this.fireChange();
        this.changeSupport.fireEvent(new MapChangeEvent<K, V>(this, diff));
    }

    protected void checkRealm() {
        Assert.isTrue((boolean)this.getRealm().isCurrent(), (String)"This operation must be run within the observable's realm");
    }

    private final class PrivateChangeSupport
    extends ChangeSupport {
        private PrivateChangeSupport(Realm realm) {
            super(realm);
        }

        protected void firstListenerAdded() {
            AbstractObservableMap.this.firstListenerAdded();
        }

        protected void lastListenerRemoved() {
            AbstractObservableMap.this.lastListenerRemoved();
        }

        protected boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

