/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingObservableValue<T>
extends DecoratingObservable
implements IObservableValue<T> {
    private IObservableValue<T> decorated;
    private IValueChangeListener<T> valueChangeListener;

    public DecoratingObservableValue(IObservableValue<T> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<T> listener) {
        this.addListener(ValueChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeValueChangeListener(IValueChangeListener<T> listener) {
        this.removeListener(ValueChangeEvent.TYPE, listener);
    }

    protected void fireValueChange(ValueDiff<T> diff) {
        super.fireChange();
        this.fireEvent(new ValueChangeEvent<T>(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireValueChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.valueChangeListener == null) {
            this.valueChangeListener = new IValueChangeListener<T>(){

                @Override
                public void handleValueChange(ValueChangeEvent<T> event) {
                    DecoratingObservableValue.this.handleValueChange(event);
                }
            };
        }
        this.decorated.addValueChangeListener(this.valueChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.valueChangeListener != null) {
            this.decorated.removeValueChangeListener(this.valueChangeListener);
            this.valueChangeListener = null;
        }
    }

    protected void handleValueChange(ValueChangeEvent<T> event) {
        this.fireValueChange(event.diff);
    }

    @Override
    public T getValue() {
        this.getterCalled();
        return this.decorated.getValue();
    }

    @Override
    public void setValue(T value) {
        this.checkRealm();
        this.decorated.setValue(value);
    }

    @Override
    public Object getValueType() {
        return this.decorated.getValueType();
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.valueChangeListener != null) {
            this.decorated.removeValueChangeListener(this.valueChangeListener);
        }
        this.decorated = null;
        this.valueChangeListener = null;
        super.dispose();
    }
}

