/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.property.map.DelegatingMapProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousBeanMapProperty<S, K, V>
extends DelegatingMapProperty<S, K, V> {
    private final String propertyName;
    private Map<Class<? extends S>, IMapProperty<S, K, V>> delegates;

    public AnonymousBeanMapProperty(String propertyName, Class<K> keyType, Class<V> valueType) {
        super(keyType, valueType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<? extends S>, IMapProperty<S, K, V>>();
    }

    protected IMapProperty<S, K, V> doGetDelegate(S source) {
        IBeanMapProperty delegate;
        Class<S> beanClass = Util.getClass(source);
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = BeanProperties.map(beanClass, this.propertyName, this.getKeyClass(), this.getValueClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{:}";
        Class keyType = this.getKeyClass();
        Class valueType = this.getValueClass();
        if (keyType != null || valueType != null) {
            s = String.valueOf(s) + " <" + BeanPropertyHelper.shortClassName(keyType) + ", " + BeanPropertyHelper.shortClassName(valueType) + ">";
        }
        return s;
    }
}

