/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class GroupDescription
extends ContainerDescription {
    public GroupDescription(IFolder group) {
        super((IContainer)group);
        this.name = group.getName();
    }

    public IResource createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.getWorkspace().getRoot();
        IPath folderPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFolder(folderPath);
    }

    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IFolder));
        if (resource.exists()) {
            return;
        }
        IFolder folderHandle = (IFolder)resource;
        try {
            monitor.beginTask("", 200);
            monitor.setTaskName(UndoMessages.GroupDescription_NewGroupProgress);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            folderHandle.createGroup(16, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createChildResources((IContainer)folderHandle, monitor, 100);
        }
        finally {
            monitor.done();
        }
    }
}

