/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button executableBox;
    private Button archiveBox;
    private Button derivedBox;
    private boolean previousReadOnlyValue;
    private boolean previousExecutableValue;
    private boolean previousArchiveValue;
    private boolean previousDerivedValue;
    private IContentDescription cachedContentDescription;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineDelimiterEditor;
    private static String READ_ONLY = IDEWorkbenchMessages.ResourceInfo_readOnly;
    private static String EXECUTABLE = IDEWorkbenchMessages.ResourceInfo_executable;
    private static String ARCHIVE = IDEWorkbenchMessages.ResourceInfo_archive;
    private static String DERIVED = IDEWorkbenchMessages.ResourceInfo_derived;
    private static String TYPE_TITLE = IDEWorkbenchMessages.ResourceInfo_type;
    private static String LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_location;
    private static String RESOLVED_LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_resolvedLocation;
    private static String SIZE_TITLE = IDEWorkbenchMessages.ResourceInfo_size;
    private static String PATH_TITLE = IDEWorkbenchMessages.ResourceInfo_path;
    private static String TIMESTAMP_TITLE = IDEWorkbenchMessages.ResourceInfo_lastModified;
    private static String FILE_ENCODING_TITLE = IDEWorkbenchMessages.WorkbenchPreference_encoding;
    private static String CONTAINER_ENCODING_TITLE = IDEWorkbenchMessages.ResourceInfo_fileEncodingTitle;
    private static String EDIT_TITLE = IDEWorkbenchMessages.ResourceInfo_edit;
    private Text resolvedLocationValue = null;
    private Text locationValue = null;
    private Text sizeValue = null;
    private IPath newResourceLocation = null;
    private static final int MAX_VALUE_WIDTH = 80;
    static /* synthetic */ Class class$0;

    private Composite createBasicInfoGroup(Composite parent, IResource resource) {
        Label locationTitle;
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        Text pathValueText = new Text(basicInfoComposite, 72);
        String pathString = TextProcessor.process((String)resource.getFullPath().toString());
        pathValueText.setText(pathString);
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setBackground(pathValueText.getDisplay().getSystemColor(22));
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        Text typeValue = new Text(basicInfoComposite, 16392);
        typeValue.setText(IDEResourceInfoUtils.getTypeString(resource, this.getContentDescription(resource)));
        typeValue.setBackground(typeValue.getDisplay().getSystemColor(22));
        if (resource.isLinked()) {
            locationTitle = new Label(basicInfoComposite, 16384);
            locationTitle.setText(LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            locationTitle.setLayoutData((Object)gd);
            Composite locationComposite = new Composite(basicInfoComposite, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            locationComposite.setLayout((Layout)layout);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            locationComposite.setLayoutData((Object)gd);
            this.locationValue = new Text(locationComposite, 72);
            String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            this.locationValue.setText(locationStr);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.locationValue.setLayoutData((Object)gd);
            this.locationValue.setBackground(this.locationValue.getDisplay().getSystemColor(22));
            Button editButton = new Button(locationComposite, 8);
            editButton.setText(EDIT_TITLE);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(EDIT_TITLE.length()) * 2 + 40;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            editButton.setLayoutData((Object)gd);
            editButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ResourceInfoPage.this.editLinkLocation();
                }

                public void widgetSelected(SelectionEvent e) {
                    ResourceInfoPage.this.editLinkLocation();
                }
            });
            Label resolvedLocationTitle = new Label(basicInfoComposite, 16384);
            resolvedLocationTitle.setText(RESOLVED_LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            resolvedLocationTitle.setLayoutData((Object)gd);
            this.resolvedLocationValue = new Text(basicInfoComposite, 72);
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.resolvedLocationValue.setLayoutData((Object)gd);
            this.resolvedLocationValue.setBackground(this.resolvedLocationValue.getDisplay().getSystemColor(22));
        } else if (!resource.isGroup()) {
            locationTitle = new Label(basicInfoComposite, 16384);
            locationTitle.setText(LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            locationTitle.setLayoutData((Object)gd);
            Text locationValue = new Text(basicInfoComposite, 72);
            String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            locationValue.setText(locationStr);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            locationValue.setLayoutData((Object)gd);
            locationValue.setBackground(locationValue.getDisplay().getSystemColor(22));
        }
        if (resource.getType() == 1) {
            Label sizeTitle = new Label(basicInfoComposite, 16384);
            sizeTitle.setText(SIZE_TITLE);
            Text sizeValue = new Text(basicInfoComposite, 16392);
            sizeValue.setText(IDEResourceInfoUtils.getSizeString(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            sizeValue.setLayoutData((Object)gd);
            sizeValue.setBackground(sizeValue.getDisplay().getSystemColor(22));
        }
        return basicInfoComposite;
    }

    protected void editLinkLocation() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        IPath location = Path.fromPortableString((String)this.locationValue.getText());
        PathVariableDialog dialog = new PathVariableDialog(this.getShell(), 3, resource.getType(), resource.getProject().getPathVariableManager(), null);
        dialog.setLinkLocation(location);
        dialog.setProject(resource.getProject());
        if (dialog.open() == 1) {
            return;
        }
        this.newResourceLocation = location = Path.fromOSString((String)dialog.getVariableValue());
        this.refreshLinkLocation();
    }

    private void refreshLinkLocation() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        this.locationValue.setText(this.newResourceLocation.toPortableString());
        IPath resolved = resource.getProject().getPathVariableManager().resolvePath(this.newResourceLocation);
        if (!IDEResourceInfoUtils.exists(resolved.toOSString())) {
            this.resolvedLocationValue.setText(IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_notExist);
            }
        } else {
            this.resolvedLocationValue.setText(resolved.toPortableString());
            if (this.sizeValue != null) {
                IFileInfo info = IDEResourceInfoUtils.getFileInfo(resolved.toPortableString());
                if (info != null) {
                    this.sizeValue.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_bytes, (Object)Long.toString(info.getLength())));
                } else {
                    this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_unknown);
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        IResource resource;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_info_property_page_context");
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            Label label = new Label(parent, 0);
            label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
            return label;
        }
        if (resource.getType() != 4) {
            ResourceAttributes attrs = resource.getResourceAttributes();
            if (attrs != null) {
                this.previousReadOnlyValue = attrs.isReadOnly();
                this.previousExecutableValue = attrs.isExecutable();
                this.previousArchiveValue = attrs.isArchive();
            } else {
                this.previousArchiveValue = false;
                this.previousExecutableValue = false;
                this.previousReadOnlyValue = false;
            }
            this.previousDerivedValue = resource.isDerived();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createBasicInfoGroup(composite, resource);
        this.createSeparator(composite);
        this.createStateGroup(composite, resource);
        new Label(composite, 0);
        this.encodingEditor = new ResourceEncodingFieldEditor(this.getFieldEditorLabel(resource), composite, resource);
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ResourceInfoPage.this.setValid(ResourceInfoPage.this.encodingEditor.isValid());
                }
            }
        });
        if (resource.getType() == 4) {
            this.lineDelimiterEditor = new LineDelimiterEditor(composite, resource.getProject());
            this.lineDelimiterEditor.doLoad();
        }
        if (resource.getType() == 4 && !((IProject)resource).isOpen()) {
            this.encodingEditor.setEnabled(false, composite);
            this.lineDelimiterEditor.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String getFieldEditorLabel(IResource resource) {
        if (resource instanceof IContainer) {
            return CONTAINER_ENCODING_TITLE;
        }
        return FILE_ENCODING_TITLE;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.editableBox.setLayoutData((Object)data);
    }

    private void createExecutableButton(Composite composite) {
        this.executableBox = new Button(composite, 131104);
        this.executableBox.setAlignment(16384);
        this.executableBox.setText(EXECUTABLE);
        this.executableBox.setSelection(this.previousExecutableValue);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.executableBox.setLayoutData((Object)data);
    }

    private void createArchiveButton(Composite composite) {
        this.archiveBox = new Button(composite, 131104);
        this.archiveBox.setAlignment(16384);
        this.archiveBox.setText(ARCHIVE);
        this.archiveBox.setSelection(this.previousArchiveValue);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.archiveBox.setLayoutData((Object)data);
    }

    private void createDerivedButton(Composite composite) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        this.derivedBox.setText(DERIVED);
        this.derivedBox.setSelection(this.previousDerivedValue);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.derivedBox.setLayoutData((Object)data);
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label timeStampLabel = new Label(composite, 0);
        timeStampLabel.setText(TIMESTAMP_TITLE);
        Text timeStampValue = new Text(composite, 8);
        timeStampValue.setText(IDEResourceInfoUtils.getDateStringValue(resource));
        timeStampValue.setBackground(timeStampValue.getDisplay().getSystemColor(22));
        timeStampValue.setLayoutData((Object)new GridData(768));
        if (resource.getType() != 4) {
            URI location;
            if (!resource.isGroup() && (location = resource.getLocationURI()) != null && location.getScheme() != null) {
                try {
                    IFileSystem fs = EFS.getFileSystem((String)location.getScheme());
                    int attributes = fs.attributes();
                    if ((attributes & 2) != 0) {
                        this.createEditableButton(composite);
                    }
                    if ((attributes & 4) != 0) {
                        this.createExecutableButton(composite);
                    }
                    if ((attributes & 8) != 0) {
                        this.createArchiveButton(composite);
                    }
                }
                catch (CoreException coreException) {}
            }
            this.createDerivedButton(composite);
            if (this.executableBox != null && resource.getType() == 2) {
                Composite noteComposite = this.createNoteComposite(font, composite, IDEWorkbenchMessages.Preference_note, IDEWorkbenchMessages.ResourceInfo_exWarning);
                GridData noteData = new GridData();
                noteData.horizontalSpan = 2;
                noteComposite.setLayoutData((Object)noteData);
            }
        }
    }

    private IContentDescription getContentDescription(IResource resource) {
        if (resource.getType() != 1) {
            return null;
        }
        if (this.cachedContentDescription == null) {
            try {
                this.cachedContentDescription = ((IFile)resource).getContentDescription();
            }
            catch (CoreException coreException) {}
        }
        return this.cachedContentDescription;
    }

    protected void performDefaults() {
        IResource resource;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (this.newResourceLocation != null) {
            this.newResourceLocation = null;
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(resource));
            String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            this.locationValue.setText(locationStr);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEResourceInfoUtils.getSizeString(resource));
            }
        }
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.executableBox != null) {
            this.executableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
        this.encodingEditor.loadDefault();
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.loadDefault();
        }
    }

    public boolean performOk() {
        IResource resource;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            return true;
        }
        this.encodingEditor.store();
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.store();
        }
        try {
            boolean localDerivedValue;
            ResourceAttributes attrs;
            if (this.newResourceLocation != null) {
                resource.setLinkLocation(this.newResourceLocation, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            if ((attrs = resource.getResourceAttributes()) != null) {
                boolean hasChange = false;
                if (this.editableBox != null && this.editableBox.getSelection() != this.previousReadOnlyValue) {
                    attrs.setReadOnly(this.editableBox.getSelection());
                    hasChange = true;
                }
                if (this.executableBox != null && this.executableBox.getSelection() != this.previousExecutableValue) {
                    attrs.setExecutable(this.executableBox.getSelection());
                    hasChange = true;
                }
                if (this.archiveBox != null && this.archiveBox.getSelection() != this.previousArchiveValue) {
                    attrs.setArchive(this.archiveBox.getSelection());
                    hasChange = true;
                }
                if (hasChange) {
                    resource.setResourceAttributes(attrs);
                    attrs = resource.getResourceAttributes();
                    if (attrs != null) {
                        this.previousReadOnlyValue = attrs.isReadOnly();
                        this.previousExecutableValue = attrs.isExecutable();
                        this.previousArchiveValue = attrs.isArchive();
                        if (this.editableBox != null) {
                            this.editableBox.setSelection(attrs.isReadOnly());
                        }
                        if (this.executableBox != null) {
                            this.executableBox.setSelection(attrs.isExecutable());
                        }
                        if (this.archiveBox != null) {
                            this.archiveBox.setSelection(attrs.isArchive());
                        }
                    }
                }
            }
            if (this.derivedBox != null && this.previousDerivedValue != (localDerivedValue = this.derivedBox.getSelection())) {
                boolean isDerived;
                resource.setDerived(localDerivedValue);
                this.previousDerivedValue = isDerived = resource.isDerived();
                this.derivedBox.setSelection(isDerived);
            }
        }
        catch (CoreException exception) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.InternalError, (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
            return false;
        }
        return true;
    }
}

