/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.resources.ProjectPathVariableManager;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PathVariablesGroup {
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private Shell shell;
    private Label variableLabel;
    private Table variableTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FontMetrics fontMetrics;
    private boolean multiSelect;
    private int variableType;
    private Listener selectionListener;
    private SortedMap tempPathVariables;
    private Set removedVariableNames;
    private IPathVariableManager pathVariableManager;
    private final Image FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image FOLDER_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image BUILTIN_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image imageUnkown;
    private IProject currentProject = null;
    private static final String PARENT_VARIABLE_NAME = "PARENT";

    public PathVariablesGroup(boolean multiSelect, int variableType) {
        this.multiSelect = multiSelect;
        this.variableType = variableType;
        this.pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public PathVariablesGroup(boolean multiSelect, int variableType, Listener selectionListener) {
        this(multiSelect, variableType);
        this.selectionListener = selectionListener;
    }

    private void addNewVariable() {
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 1, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        dialog.setProject(this.currentProject);
        if (dialog.open() == 1) {
            return;
        }
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        if (this.imageUnkown == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/warning.gif");
            this.imageUnkown = descriptor.createImage();
        }
        this.initializeDialogUnits((Control)parent);
        this.shell = parent.getShell();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        this.variableLabel = new Label(pageComponent, 16384);
        if (this.currentProject == null) {
            this.variableLabel.setText(IDEWorkbenchMessages.PathVariablesBlock_variablesLabel);
        } else {
            this.variableLabel.setText(NLS.bind((String)IDEWorkbenchMessages.PathVariablesBlock_variablesLabelForProject, (Object)this.currentProject.getName()));
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.variableLabel.setLayoutData((Object)data);
        this.variableLabel.setFont(font);
        int tableStyle = 67584;
        if (this.multiSelect) {
            tableStyle |= 2;
        }
        this.variableTable = new Table(pageComponent, tableStyle);
        this.variableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.updateEnabledState();
                if (PathVariablesGroup.this.selectionListener != null) {
                    PathVariablesGroup.this.selectionListener.handleEvent(new Event());
                }
            }
        });
        TableColumn tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_nameColumn);
        tableColumn.setWidth(150);
        tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_valueColumn);
        tableColumn.setWidth(250);
        tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_resolvedValueColumn);
        tableColumn.setWidth(250);
        this.variableTable.setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = this.variableTable.getItemHeight() * 7;
        this.variableTable.setLayoutData((Object)data);
        this.variableTable.setFont(font);
        this.createButtonGroup(pageComponent);
        this.updateWidgetState(null);
        return pageComponent;
    }

    public void dispose() {
        if (this.imageUnkown != null) {
            this.imageUnkown.dispose();
            this.imageUnkown = null;
        }
    }

    private void editSelectedVariable() {
        TableItem item = this.variableTable.getItem(this.variableTable.getSelectionIndex());
        String variableName = (String)item.getData();
        IPath variableValue = (IPath)this.tempPathVariables.get(variableName);
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 2, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        dialog.setVariableName(variableName);
        dialog.setVariableValue(variableValue.toOSString());
        dialog.setProject(this.currentProject);
        if (dialog.open() == 1) {
            return;
        }
        this.removedVariableNames.add(variableName);
        this.tempPathVariables.remove(variableName);
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public boolean getEnabled() {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            return this.variableTable.getEnabled();
        }
        return true;
    }

    public PathVariableElement[] getSelection() {
        if (this.variableTable == null) {
            return new PathVariableElement[0];
        }
        TableItem[] items = this.variableTable.getSelection();
        PathVariableElement[] selection = new PathVariableElement[items.length];
        int i = 0;
        while (i < items.length) {
            String name = (String)items[i].getData();
            selection[i] = new PathVariableElement();
            selection[i].name = name;
            selection[i].path = (IPath)this.tempPathVariables.get(name);
            ++i;
        }
        return selection;
    }

    private void createButtonGroup(Composite parent) {
        Font font = parent.getFont();
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(IDEWorkbenchMessages.PathVariablesBlock_addVariableButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.addNewVariable();
            }
        });
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(IDEWorkbenchMessages.PathVariablesBlock_editVariableButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.editSelectedVariable();
            }
        });
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(IDEWorkbenchMessages.PathVariablesBlock_removeVariableButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.removeSelectedVariables();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void initTemporaryState() {
        String[] varNames = this.pathVariableManager.getPathVariableNames();
        this.tempPathVariables.clear();
        int i = 0;
        while (i < varNames.length) {
            boolean isFile;
            IPath value;
            if (!varNames[i].equals(PARENT_VARIABLE_NAME) && (value = this.pathVariableManager.getValue(varNames[i])) != null && ((isFile = value.toFile().isFile()) && (this.variableType & 1) != 0 || !isFile && (this.variableType & 2) != 0)) {
                this.tempPathVariables.put(varNames[i], value);
            }
            ++i;
        }
        this.removedVariableNames.clear();
    }

    private void updateEnabledState() {
        int itemsSelectedCount = this.variableTable.getSelectionCount();
        this.editButton.setEnabled(itemsSelectedCount == 1 && this.canChangeSelection());
        this.removeButton.setEnabled(itemsSelectedCount > 0 && this.canChangeSelection());
    }

    private void updateVariableTable(String selectedVarName) {
        this.variableTable.removeAll();
        int selectedVarIndex = 0;
        Iterator varNames = this.tempPathVariables.keySet().iterator();
        while (varNames.hasNext()) {
            IPath value;
            TableItem item = new TableItem(this.variableTable, 0);
            String varName = (String)varNames.next();
            IPath resolvedValue = value = (IPath)this.tempPathVariables.get(varName);
            if (this.currentProject != null) {
                resolvedValue = this.currentProject.getPathVariableManager().resolvePath(resolvedValue);
            }
            IFileInfo file = IDEResourceInfoUtils.getFileInfo(resolvedValue);
            item.setText(0, varName);
            item.setText(1, this.removeParentVariable(value.toOSString()));
            item.setText(2, resolvedValue.toOSString());
            item.setData((Object)varName);
            if (!this.isBuiltInVariable(varName)) {
                item.setImage(file.exists() ? (file.isDirectory() ? this.FOLDER_IMG : this.FILE_IMG) : this.imageUnkown);
            } else {
                item.setImage(this.BUILTIN_IMG);
            }
            if (!varName.equals(selectedVarName)) continue;
            selectedVarIndex = this.variableTable.getItemCount() - 1;
        }
        if (this.variableTable.getItemCount() > selectedVarIndex) {
            this.variableTable.setSelection(selectedVarIndex);
            if (this.selectionListener != null) {
                this.selectionListener.handleEvent(new Event());
            }
        } else if (this.variableTable.getItemCount() == 0 && this.selectionListener != null) {
            this.selectionListener.handleEvent(new Event());
        }
    }

    private String removeParentVariable(String value) {
        return ProjectPathVariableManager.convertToUserEditableFormat((String)value);
    }

    public boolean performOk() {
        try {
            Iterator removed = this.removedVariableNames.iterator();
            while (removed.hasNext()) {
                String removedVariableName = (String)removed.next();
                if (this.tempPathVariables.containsKey(removedVariableName)) continue;
                this.pathVariableManager.setValue(removedVariableName, null);
            }
            Iterator current = this.tempPathVariables.entrySet().iterator();
            while (current.hasNext()) {
                Map.Entry entry = current.next();
                String variableName = (String)entry.getKey();
                IPath variableValue = (IPath)entry.getValue();
                if (this.isBuiltInVariable(variableName)) continue;
                this.pathVariableManager.setValue(variableName, variableValue);
            }
            this.initTemporaryState();
            return true;
        }
        catch (CoreException ce) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)ce.getStatus());
            return false;
        }
    }

    private void removeSelectedVariables() {
        int[] selectedIndices = this.variableTable.getSelectionIndices();
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem selectedItem = this.variableTable.getItem(selectedIndices[i]);
            String varName = (String)selectedItem.getData();
            this.removedVariableNames.add(varName);
            this.tempPathVariables.remove(varName);
            ++i;
        }
        this.updateWidgetState(null);
    }

    private boolean canChangeSelection() {
        int[] selectedIndices = this.variableTable.getSelectionIndices();
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem selectedItem = this.variableTable.getItem(selectedIndices[i]);
            String varName = (String)selectedItem.getData();
            if (this.isBuiltInVariable(varName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isBuiltInVariable(String varName) {
        ProjectVariableProviderManager.Descriptor[] descriptors;
        if (this.currentProject != null && (descriptors = ProjectVariableProviderManager.getDefault().getDescriptors()) != null) {
            int j = 0;
            while (j < descriptors.length) {
                if (varName.equals(descriptors[j].getName())) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    public void setEnabled(boolean enabled) {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            this.variableLabel.setEnabled(enabled);
            this.variableTable.setEnabled(enabled);
            this.addButton.setEnabled(enabled);
            if (enabled) {
                this.updateEnabledState();
            } else {
                this.editButton.setEnabled(enabled);
                this.removeButton.setEnabled(enabled);
            }
        }
    }

    private void updateWidgetState(String selectedVarName) {
        this.updateVariableTable(selectedVarName);
        this.updateEnabledState();
    }

    public void setProject(IProject project) {
        this.currentProject = project;
        this.pathVariableManager = project.getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public void reloadContent() {
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
        if (this.variableTable != null) {
            this.updateWidgetState(null);
        }
    }

    public static class PathVariableElement {
        public String name;
        public IPath path;
    }
}

