/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.misc.CompoundFilter;

class FilterCopy
implements IFilter {
    static String EMPTY = "";
    String arguments = EMPTY;
    String id = null;
    IPath path = null;
    IProject project = null;
    int type = 0;
    FilterCopy parent = null;
    LinkedList children = null;
    IFilter original = null;
    int serialNumber = ++lastSerialNumber;
    private static int lastSerialNumber = 0;

    public FilterCopy(IFilter filter) {
        this.internalCopy(filter);
        this.original = filter;
    }

    public void setParent(FilterCopy parent) {
        this.parent = parent;
    }

    public boolean canAcceptDrop() {
        int limit = this.getChildrenLimit();
        if (limit > 0) {
            FilterCopy[] tmp = this.getChildren();
            return tmp == null || tmp.length < limit;
        }
        return false;
    }

    public boolean hasParent(FilterCopy filterCopy) {
        FilterCopy filter = this;
        do {
            if (!filter.equals(filterCopy)) continue;
            return true;
        } while ((filter = filter.getParent()) != null);
        return false;
    }

    public FilterCopy getParent() {
        return this.parent;
    }

    public void copy(IFilter filter) {
        this.internalCopy(filter);
        this.argumentsChanged();
    }

    private void internalCopy(IFilter filter) {
        this.children = null;
        this.arguments = filter.getArguments();
        this.id = filter.getId();
        this.path = filter.getPath();
        this.project = filter.getProject();
        this.type = filter.getType();
        if (this.arguments == null) {
            this.arguments = EMPTY;
        }
    }

    public boolean hasChanged() {
        if (this.original != null) {
            return !(this.arguments == null ? this.original.getArguments() == null : this.arguments.equals(this.original.getArguments())) || !this.id.equals(this.original.getId()) || this.type != this.original.getType();
        }
        return true;
    }

    public FilterCopy() {
        this.path = null;
        this.project = null;
        this.type = 5;
        this.id = FilterTypeUtil.getDefaultFilterID();
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getId() {
        return this.id;
    }

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getType() {
        return this.type;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
        this.argumentsChanged();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasStringArguments() {
        FilterTypeManager.Descriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            return descriptor.getArgumentType().equals("string");
        }
        return false;
    }

    public int getChildrenLimit() {
        FilterTypeManager.Descriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            if (descriptor.getArgumentType().equals("filter")) {
                return 1;
            }
            if (descriptor.getArgumentType().equals("filters")) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilterCopy)) {
            return false;
        }
        FilterCopy filter = (FilterCopy)o;
        return this.serialNumber == filter.serialNumber;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public FilterCopy findBySerialNumber(int number) {
        LinkedList<FilterCopy> pending = new LinkedList<FilterCopy>();
        pending.add(this);
        while (!pending.isEmpty()) {
            FilterCopy filter = (FilterCopy)pending.getFirst();
            pending.removeFirst();
            if (filter.serialNumber == number) {
                return filter;
            }
            FilterCopy[] tmp = filter.getChildren();
            if (tmp == null) continue;
            pending.addAll(Arrays.asList(tmp));
        }
        return null;
    }

    public FilterCopy[] getChildren() {
        if (this.getChildrenLimit() > 0) {
            this.initializeChildren();
            return this.children.toArray(new FilterCopy[0]);
        }
        return null;
    }

    protected void initializeChildren() {
        if (this.children == null && this.getChildrenLimit() > 0) {
            this.children = new LinkedList();
            IFilter[] filters = CompoundFilter.unserialize(this.getProject(), this.getArguments());
            int i = 0;
            while (i < filters.length) {
                FilterCopy child = new FilterCopy(filters[i]);
                child.parent = this;
                this.children.add(child);
                ++i;
            }
        }
    }

    public void addChild(FilterCopy child) {
        this.initializeChildren();
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        this.children.add(child);
        child.parent = this;
        this.serializeChildren();
    }

    public void removeChild(FilterCopy child) {
        this.initializeChildren();
        this.children.remove(child);
        if (child.parent == this) {
            child.parent = null;
        }
        this.serializeChildren();
    }

    protected void serializeChildren() {
        this.initializeChildren();
        this.argumentsChanged();
    }

    protected void argumentsChanged() {
        this.initializeChildren();
        if (this.children != null) {
            this.arguments = CompoundFilter.serialize(this.children.toArray(new FilterCopy[0]));
        }
        FilterCopy up = this.parent;
        while (up != null) {
            up.serializeChildren();
            up = up.parent;
        }
    }

    public boolean isUnderAGroupFilter() {
        return this.parent != null && this.parent.getChildrenLimit() > 0 && this.parent.getParent() != null;
    }
}

