/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.dialogs.PathVariableEditDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ImportTypeDialog
extends MessageDialog
implements SelectionListener {
    public static final String AUTOMATIC = "PROJECT_LOC";
    public static final String ABSOLUTE_PATH = "default";
    public static final int IMPORT_COPY = 1;
    public static final int IMPORT_GROUPS_AND_LINKS = 2;
    public static final int IMPORT_LINK = 4;
    public static final int IMPORT_MOVE = 8;
    public static final int IMPORT_NONE = 0;
    private int operationMask;
    private int currentSelection;
    private Button copyButton = null;
    private Button shadowCopyButton = null;
    private Button linkButton = null;
    private Button moveButton = null;
    private Combo variableCombo = null;
    private Button alwaysPerformThisOperation = null;
    private Label variableLabel = null;
    private String variable = "default";
    private IProject receivingProject = null;

    public ImportTypeDialog(Shell parentShell, int operationMask) {
        super(parentShell, IDEWorkbenchMessages.ImportTypeDialog_title, null, IDEWorkbenchMessages.ImportTypeDialog_question, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.operationMask = operationMask;
        this.currentSelection = 0;
        String tmp = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE");
        if (tmp.length() > 0) {
            this.currentSelection = Integer.parseInt(tmp);
        }
        this.currentSelection &= operationMask;
        if (this.currentSelection == 0) {
            this.currentSelection = (operationMask & 1) != 0 ? 1 : 8;
        }
    }

    private String readContextPreference(String key) {
        String value = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        String[] keyPairs = value.split(":");
        int i = 0;
        while (i < keyPairs.length) {
            String[] element = keyPairs[i].split(",");
            if (element.length == 2 && element[0].equals(Integer.toString(this.operationMask))) {
                return element[1];
            }
            ++i;
        }
        return "";
    }

    private void writeContextPreference(String key, String value) {
        String oldValue = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        StringBuffer buffer = new StringBuffer();
        String[] keyPairs = oldValue.split(":");
        boolean found = false;
        int i = 0;
        while (i < keyPairs.length) {
            String[] element;
            if (i > 0) {
                buffer.append(":");
            }
            if ((element = keyPairs[i].split(",")).length == 2) {
                if (element[0].equals(Integer.toString(this.operationMask))) {
                    buffer.append(String.valueOf(element[0]) + "," + value);
                    found = true;
                } else {
                    buffer.append(keyPairs[i]);
                }
            }
            ++i;
        }
        if (!found) {
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append(String.valueOf(Integer.toString(this.operationMask)) + "," + value);
        }
        String newValue = buffer.toString();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(key, newValue);
    }

    public String getVariable() {
        if (this.variable == ABSOLUTE_PATH) {
            return null;
        }
        return this.variable;
    }

    public int getSelection() {
        return this.currentSelection;
    }

    public int open() {
        String showDialogMap = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_SHOW_DIALOG");
        if (showDialogMap.length() == 0 || !Boolean.valueOf(showDialogMap).booleanValue()) {
            return super.open();
        }
        return 0;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.marginLeft = 32;
        composite.setLayout((Layout)layout);
        if ((this.operationMask & 1) != 0) {
            this.copyButton = new Button(composite, 16);
            this.copyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_copyFilesAndDirectories);
            gridData = new GridData(768);
            this.copyButton.setLayoutData((Object)gridData);
            this.copyButton.setData((Object)new Integer(1));
            this.copyButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 8) != 0) {
            this.moveButton = new Button(composite, 16);
            this.moveButton.setText(IDEWorkbenchMessages.ImportTypeDialog_moveFilesAndDirectories);
            gridData = new GridData(768);
            this.moveButton.setLayoutData((Object)gridData);
            this.moveButton.setData((Object)new Integer(8));
            this.moveButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 2) != 0) {
            this.shadowCopyButton = new Button(composite, 16);
            this.shadowCopyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_recreateFilesAndDirectories);
            gridData = new GridData(768);
            this.shadowCopyButton.setLayoutData((Object)gridData);
            this.shadowCopyButton.setData((Object)new Integer(2));
            this.shadowCopyButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 4) != 0) {
            this.linkButton = new Button(composite, 16);
            this.linkButton.setText(IDEWorkbenchMessages.ImportTypeDialog_createLinks);
            gridData = new GridData(768);
            this.linkButton.setLayoutData((Object)gridData);
            this.linkButton.setData((Object)new Integer(4));
            this.linkButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 6) != 0) {
            Composite variableGroup = new Composite(composite, 0);
            gridData = new GridData(4, 4, true, true);
            variableGroup.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 9;
            variableGroup.setLayout((Layout)layout);
            this.variableLabel = new Label(variableGroup, 0);
            this.variableLabel.setText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAs);
            gridData = new GridData(32);
            this.variableLabel.setLayoutData((Object)gridData);
            this.variableCombo = new Combo(variableGroup, 12);
            gridData = new GridData(32);
            this.variableCombo.setLayoutData((Object)gridData);
            this.variableCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }
            });
            this.setupVariableContent();
            this.selectVariable(this.readContextPreference("IMPORT_FILES_AND_FOLDERS_VARIABLE"));
        }
        this.alwaysPerformThisOperation = new Button(composite, 32);
        this.alwaysPerformThisOperation.setText(IDEWorkbenchMessages.ImportTypeDialog_alwaysPerformThisOperation);
        gridData = new GridData(32);
        this.alwaysPerformThisOperation.setLayoutData((Object)gridData);
        this.refreshSelection();
        return composite;
    }

    private void editVariables() {
        String[] variableNames;
        PathVariableEditDialog dialog = new PathVariableEditDialog(this.getShell());
        dialog.setProject(this.receivingProject);
        if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length >= 1) {
            this.variable = variableNames[0];
        }
        this.setupVariableContent();
        this.selectVariable(this.variable);
    }

    private void selectVariable(String var) {
        if (var.equals(IDEWorkbenchMessages.ImportTypeDialog_automatic) || var.equals(AUTOMATIC)) {
            this.variableCombo.select(0);
            this.variable = var;
        } else if (var.equals(IDEWorkbenchMessages.ImportTypeDialog_absolutePath) || var.equals(ABSOLUTE_PATH)) {
            this.variableCombo.select(1);
            this.variable = var;
        } else {
            String[] items = this.variableCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (var.equals(items[i])) {
                    this.variableCombo.select(i);
                    this.variable = i == 0 ? AUTOMATIC : (i == 1 ? ABSOLUTE_PATH : items[i]);
                    return;
                }
                ++i;
            }
            this.variableCombo.select(0);
            this.variable = AUTOMATIC;
        }
    }

    private void setupVariableContent() {
        IPathVariableManager pathVariableManager = this.receivingProject != null ? this.receivingProject.getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
        String[] variables = pathVariableManager.getPathVariableNames();
        String[] items = new String[variables.length + 3];
        items[0] = IDEWorkbenchMessages.ImportTypeDialog_automatic;
        items[1] = IDEWorkbenchMessages.ImportTypeDialog_absolutePath;
        int i = 0;
        while (i < variables.length) {
            items[i + 2] = variables[i];
            ++i;
        }
        items[items.length - 1] = IDEWorkbenchMessages.ImportTypeDialog_editVariables;
        this.variableCombo.setItems(items);
        super.getShell().layout(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE", Integer.toString(this.currentSelection));
            String storageVariable = this.currentSelection == 0 ? AUTOMATIC : (this.currentSelection == 1 ? ABSOLUTE_PATH : this.variable);
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_VARIABLE", storageVariable);
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_SHOW_DIALOG", Boolean.toString(this.alwaysPerformThisOperation.getSelection()));
        }
        super.buttonPressed(buttonId);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.currentSelection = (Integer)e.widget.getData();
        this.refreshSelection();
    }

    public void widgetSelected(SelectionEvent e) {
        this.currentSelection = (Integer)e.widget.getData();
        this.refreshSelection();
    }

    private void refreshSelection() {
        if (this.copyButton != null) {
            this.copyButton.setSelection(this.currentSelection == 1);
        }
        if (this.shadowCopyButton != null) {
            this.shadowCopyButton.setSelection(this.currentSelection == 2);
        }
        if (this.linkButton != null) {
            this.linkButton.setSelection(this.currentSelection == 4);
        }
        if (this.moveButton != null) {
            this.moveButton.setSelection(this.currentSelection == 8);
        }
        if (this.variableCombo != null) {
            this.variableCombo.setEnabled((this.currentSelection & 6) != 0);
        }
        if (this.variableLabel != null) {
            this.variableLabel.setEnabled((this.currentSelection & 6) != 0);
        }
    }

    public void setProject(IProject project) {
        this.receivingProject = project;
    }
}

