/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.ConfigResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class ScenarioResults
extends AbstractResults {
    String fileName;
    String label;
    String shortName;

    public ScenarioResults(int id, String name, String shortName) {
        super(null, id);
        this.name = name;
        this.label = shortName;
    }

    void completeResults(String lastBuildName) {
        int size;
        String[] builds = DB_Results.getBuilds();
        class BuildDateComparator
        implements Comparator {
            final /* synthetic */ ScenarioResults this$0;

            BuildDateComparator(ScenarioResults scenarioResults) {
                this.this$0 = scenarioResults;
            }

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return AbstractResults.getBuildDate(s1).compareTo(AbstractResults.getBuildDate(s2));
            }
        }
        BuildDateComparator comparator = new BuildDateComparator(this);
        Arrays.sort(builds, comparator);
        int idx = Arrays.binarySearch(builds, lastBuildName, comparator);
        if (idx < 0) {
            builds = null;
        } else {
            size = builds.length - ++idx;
            String[] stringArray = builds;
            builds = new String[size];
            System.arraycopy(stringArray, idx, builds, 0, size);
        }
        size = this.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            configResults.completeResults(builds);
            ++i;
        }
    }

    public String getBaselineBuildName() {
        int size = this.size();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            if (configResults.isValid()) {
                return configResults.getBaselineBuildName();
            }
            ++i;
        }
        return buffer.toString();
    }

    Set getAllBuildNames() {
        HashSet<String> buildNames = new HashSet<String>();
        int size = this.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            List builds = configResults.getBuilds(null);
            int length = builds.size();
            int j = 0;
            while (j < length) {
                buildNames.add(((BuildResults)builds.get(j)).getName());
                ++j;
            }
            ++i;
        }
        return buildNames;
    }

    public ConfigResults getConfigResults(String config) {
        return (ConfigResults)this.getResults(config);
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = "Scenario" + this.id;
        }
        return this.fileName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getShortName() {
        if (this.shortName == null) {
            boolean hasClassName;
            int testSeparator = this.name.indexOf(35);
            boolean bl = hasClassName = testSeparator >= 0;
            if (!hasClassName && (testSeparator = this.name.lastIndexOf(46)) <= 0) {
                this.shortName = this.name;
                return this.shortName;
            }
            int classSeparator = this.name.substring(0, testSeparator).lastIndexOf(46);
            if (classSeparator < 0) {
                this.shortName = this.name;
                return this.shortName;
            }
            int length = this.name.length();
            String testName = this.name.substring(classSeparator + 1, length);
            if (!hasClassName && testName.startsWith("test.")) {
                testName = testName.substring(5);
            }
            StringTokenizer tokenizer = new StringTokenizer(testName, " :,", true);
            StringBuffer buffer = new StringBuffer(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                char fc = token.charAt(0);
                while (fc == ' ' || fc == ',' || fc == ':') {
                    buffer.append(token);
                    token = tokenizer.nextToken();
                    fc = token.charAt(0);
                }
                int last = token.lastIndexOf(46);
                if (last >= 3) {
                    int first = token.indexOf(46);
                    if (first == last) {
                        buffer.append(token);
                        continue;
                    }
                    buffer.append(token.substring(last + 1));
                    continue;
                }
                buffer.append(token);
            }
            this.shortName = buffer.toString();
        }
        return this.shortName;
    }

    public boolean hasSummary() {
        int size = this.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            if (configResults.getCurrentBuildResults().hasSummary()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isValid() {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            if (configResults.isValid()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValid(String config) {
        return this.getResults(config) != null;
    }

    public boolean knowsBuild(String buildName) {
        String[] stringArray;
        if (buildName == null) {
            stringArray = DB_Results.getBuilds();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = buildName;
        }
        String[] buildNames = stringArray;
        Set scenarioBuilds = this.getAllBuildNames();
        int length = buildNames.length;
        int i = 0;
        while (i < length) {
            if (!scenarioBuilds.contains(buildNames[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void readData(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        int i = 0;
        while (i < size) {
            int config_id = stream.readInt();
            ConfigResults configResults = (ConfigResults)this.getResults(config_id);
            if (configResults == null) {
                configResults = new ConfigResults((AbstractResults)this, config_id);
                this.addChild(configResults, true);
            }
            configResults.readData(stream);
            ++i;
        }
    }

    void setInfos(int config_id, int build_id, int summaryKind, String comment) {
        ConfigResults configResults = (ConfigResults)this.getResults(config_id);
        if (configResults == null) {
            configResults = new ConfigResults((AbstractResults)this, config_id);
            this.addChild(configResults, true);
        }
        configResults.setInfos(build_id, summaryKind, comment);
    }

    void setValue(int build_id, int dim_id, int config_id, int step, long value) {
        ConfigResults configResults = (ConfigResults)this.getResults(config_id);
        if (configResults == null) {
            configResults = new ConfigResults((AbstractResults)this, config_id);
            this.addChild(configResults, true);
        }
        configResults.setValue(build_id, dim_id, step, value);
    }

    boolean updateBuild(String buildName, boolean force) {
        String[] stringArray;
        if (this.knowsBuild(buildName) && !force) {
            return false;
        }
        this.print("\t+ scenario '" + this.getShortName() + "': values...");
        long start = System.currentTimeMillis();
        String configPattern = this.getPerformance().getConfigurationsPattern();
        DB_Results.queryScenarioValues(this, configPattern, buildName);
        this.print(ScenarioResults.timeString(System.currentTimeMillis() - start));
        this.print(", infos...");
        start = System.currentTimeMillis();
        int size = this.size();
        if (buildName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = buildName;
        }
        String[] builds = stringArray;
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            configResults.completeResults(builds);
            ++i;
        }
        this.println(ScenarioResults.timeString(System.currentTimeMillis() - start));
        return true;
    }

    void write(DataOutputStream stream) throws IOException {
        int size = this.size();
        stream.writeInt(this.id);
        stream.writeInt(size);
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            configResults.write(stream);
            ++i;
        }
    }
}

