/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.db.SQL;

public class SQL_Results
extends SQL {
    private PreparedStatement queryBuildAllScenarios;
    private PreparedStatement queryBuildScenarios;
    private PreparedStatement queryScenarioSummaries;
    private PreparedStatement queryAllComments;
    private PreparedStatement queryScenariosBuilds;
    private PreparedStatement queryScenarioDataPoints;
    private PreparedStatement queryScenarioTimestampDataPoints;
    private PreparedStatement queryScenarioBuildDataPoints;
    private PreparedStatement queryDimScalars;
    private PreparedStatement queryAllVariations;

    SQL_Results(Connection con) throws SQLException {
        super(con);
    }

    protected void dispose() throws SQLException {
        super.dispose();
        if (this.queryBuildScenarios != null) {
            this.queryBuildScenarios.close();
        }
        if (this.queryBuildAllScenarios != null) {
            this.queryBuildAllScenarios.close();
        }
        if (this.queryScenarioSummaries != null) {
            this.queryScenarioSummaries.close();
        }
        if (this.queryAllComments != null) {
            this.queryAllComments.close();
        }
        if (this.queryScenariosBuilds != null) {
            this.queryScenariosBuilds.close();
        }
        if (this.queryScenarioDataPoints != null) {
            this.queryScenarioDataPoints.close();
        }
        if (this.queryDimScalars != null) {
            this.queryDimScalars.close();
        }
        if (this.queryAllVariations != null) {
            this.queryAllVariations.close();
        }
    }

    ResultSet queryAllComments() throws SQLException {
        if (this.queryAllComments == null) {
            this.queryAllComments = this.fConnection.prepareStatement("select ID, KIND, TEXT from COMMENT");
        }
        return this.queryAllComments.executeQuery();
    }

    ResultSet queryAllVariations(String configPattern) throws SQLException {
        System.currentTimeMillis();
        if (this.queryAllVariations == null) {
            this.queryAllVariations = this.fConnection.prepareStatement("select KEYVALPAIRS from VARIATION where KEYVALPAIRS like ? order by KEYVALPAIRS");
        }
        this.queryAllVariations.setString(1, "%" + configPattern + "%");
        ResultSet resultSet = this.queryAllVariations.executeQuery();
        return resultSet;
    }

    ResultSet queryBuildAllScenarios(String scenarioPattern) throws SQLException {
        if (this.queryBuildAllScenarios == null) {
            String statement = "select distinct SCENARIO.ID, SCENARIO.NAME , SCENARIO.SHORT_NAME from SCENARIO where SCENARIO.NAME LIKE ? order by SCENARIO.NAME";
            this.queryBuildAllScenarios = this.fConnection.prepareStatement(statement);
        }
        this.queryBuildAllScenarios.setString(1, scenarioPattern);
        return this.queryBuildAllScenarios.executeQuery();
    }

    ResultSet queryBuildScenarios(String scenarioPattern, String buildName) throws SQLException {
        if (this.queryBuildScenarios == null) {
            String statement = "select distinct SCENARIO.ID, SCENARIO.NAME , SCENARIO.SHORT_NAME from SCENARIO, SAMPLE, VARIATION where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SAMPLE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ? order by SCENARIO.NAME";
            this.queryBuildScenarios = this.fConnection.prepareStatement(statement);
        }
        this.queryBuildScenarios.setString(1, "|build=" + buildName + '%');
        this.queryBuildScenarios.setString(2, scenarioPattern);
        return this.queryBuildScenarios.executeQuery();
    }

    ResultSet queryDimScalars(int datapointId) throws SQLException {
        if (this.queryDimScalars == null) {
            this.queryDimScalars = this.fConnection.prepareStatement("select DIM_ID, VALUE from SCALAR where DATAPOINT_ID = ? and (DIM_ID = " + InternalDimensions.CPU_TIME.getId() + " or DIM_ID = " + InternalDimensions.ELAPSED_PROCESS.getId() + ") " + "order by DIM_ID");
        }
        this.queryDimScalars.setInt(1, datapointId);
        return this.queryDimScalars.executeQuery();
    }

    ResultSet queryScenarioTimestampDataPoints(String config, int scenarioID, String lastBuildName, long lastBuildTime) throws SQLException {
        if (this.queryScenarioTimestampDataPoints == null) {
            String statement = "select DATAPOINT.ID, DATAPOINT.STEP, VARIATION.KEYVALPAIRS from SAMPLE, DATAPOINT, VARIATION where SAMPLE.SCENARIO_ID = ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID and SAMPLE.STARTTIME > ? and SAMPLE.VARIATION_ID = VARIATION.ID ORDER BY DATAPOINT.ID, DATAPOINT.STEP";
            this.queryScenarioTimestampDataPoints = this.fConnection.prepareStatement(statement);
        }
        this.queryScenarioTimestampDataPoints.setInt(1, scenarioID);
        Timestamp timestamp = new Timestamp(lastBuildTime + 18000000L);
        this.queryScenarioTimestampDataPoints.setTimestamp(2, timestamp);
        ResultSet resultSet = this.queryScenarioTimestampDataPoints.executeQuery();
        return resultSet;
    }

    ResultSet queryScenarioBuildDataPoints(String config, int scenarioID, String buildName) throws SQLException {
        if (this.queryScenarioBuildDataPoints == null) {
            String statement = "select DATAPOINT.ID, DATAPOINT.STEP, VARIATION.KEYVALPAIRS from SAMPLE, DATAPOINT, VARIATION where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SAMPLE.SCENARIO_ID = ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID ORDER BY DATAPOINT.ID, DATAPOINT.STEP";
            this.queryScenarioBuildDataPoints = this.fConnection.prepareStatement(statement);
        }
        this.queryScenarioBuildDataPoints.setString(1, "|build=" + buildName + '%');
        this.queryScenarioBuildDataPoints.setInt(2, scenarioID);
        ResultSet resultSet = this.queryScenarioBuildDataPoints.executeQuery();
        return resultSet;
    }

    ResultSet queryScenarioDataPoints(String config, int scenarioID) throws SQLException {
        System.currentTimeMillis();
        if (this.queryScenarioDataPoints == null) {
            String statement = "select DATAPOINT.ID, DATAPOINT.STEP, VARIATION.KEYVALPAIRS from VARIATION, SAMPLE, DATAPOINT where VARIATION.KEYVALPAIRS like ? and SAMPLE.VARIATION_ID = VARIATION.ID and SAMPLE.SCENARIO_ID = ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID ORDER BY DATAPOINT.ID, DATAPOINT.STEP";
            this.queryScenarioDataPoints = this.fConnection.prepareStatement(statement);
        }
        this.queryScenarioDataPoints.setString(1, "%" + config + "%");
        this.queryScenarioDataPoints.setInt(2, scenarioID);
        ResultSet resultSet = this.queryScenarioDataPoints.executeQuery();
        return resultSet;
    }

    /*
     * Unable to fully structure code
     */
    ResultSet queryScenarioSummaries(int scenarioID, String config, String[] builds) throws SQLException {
        length = builds == null ? 0 : builds.length;
        switch (length) {
            case 0: {
                buildPattern = "%";
                break;
            }
            case 1: {
                buildPattern = builds[0];
                break;
            }
            default: {
                buffer = new StringBuffer();
                idx = 0;
                block4: while (idx < builds[0].length()) {
                    ch = builds[0].charAt(idx);
                    i = 1;
                    while (i < length) {
                        if (idx == builds[i].length()) break block4;
                        if (builds[i].charAt(idx) == ch) ** GOTO lbl21
                        buffer.append('_');
                        ** GOTO lbl25
lbl21:
                        // 1 sources

                        ++i;
                    }
                    buffer.append(ch);
lbl25:
                    // 2 sources

                    ++idx;
                }
                buffer.append("%");
                buildPattern = buffer.toString();
            }
        }
        if (this.queryScenarioSummaries == null) {
            this.queryScenarioSummaries = this.fConnection.prepareStatement("select KEYVALPAIRS , IS_GLOBAL, COMMENT_ID, DIM_ID from VARIATION, SUMMARYENTRY where KEYVALPAIRS like ? and VARIATION_ID = VARIATION.ID and SCENARIO_ID = ? and (DIM_ID = " + InternalDimensions.ELAPSED_PROCESS.getId() + " or DIM_ID = 0)" + " order by VARIATION_ID, DIM_ID");
        }
        this.queryScenarioSummaries.setString(1, "|build=" + buildPattern + "||config=" + config + "||jvm=sun|");
        this.queryScenarioSummaries.setInt(2, scenarioID);
        return this.queryScenarioSummaries.executeQuery();
    }
}

