/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.ComponentResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class PerformanceResults
extends AbstractResults {
    String[] allBuildNames = null;
    Map allScenarios;
    String baselineName;
    String baselinePrefix;
    private String scenarioPattern = "%";
    private String[] components;
    String[] configNames;
    String[] sortedConfigNames;
    String[] configBoxes;
    String[] sortedConfigBoxes;
    private String configPattern;
    public static final int DEFAULT_FAILURE_THRESHOLD = 10;
    int failure_threshold = 10;

    public PerformanceResults(String name, String baseline, String baselinePrefix, PrintStream stream) {
        super(null, name);
        this.baselineName = baseline;
        this.baselinePrefix = baselinePrefix;
        this.printStream = stream;
        this.setDefaults();
    }

    public String[] getAllBuildNames() {
        if (this.allBuildNames == null) {
            this.setAllBuildNames();
        }
        return this.allBuildNames;
    }

    public String getBaselineName() {
        return this.baselineName;
    }

    String getBaselinePrefix() {
        return this.baselinePrefix;
    }

    public String getBuildDate() {
        String buildName = this.getName();
        if (buildName == null) {
            return "";
        }
        return PerformanceResults.getBuildDate(this.getName(), this.getBaselinePrefix());
    }

    public String[] getComponents() {
        return this.components;
    }

    public List getComponentScenarios(String componentName) {
        ComponentResults componentResults = (ComponentResults)this.getResults(componentName);
        if (componentResults == null) {
            return null;
        }
        return Collections.unmodifiableList(componentResults.children);
    }

    public List getComponentSummaryScenarios(String componentName, String config) {
        if (componentName == null) {
            int size = this.size();
            ArrayList scenarios = new ArrayList();
            int i = 0;
            while (i < size) {
                ComponentResults componentResults = (ComponentResults)this.children.get(i);
                scenarios.addAll(componentResults.getSummaryScenarios(true, config));
                ++i;
            }
            return scenarios;
        }
        ComponentResults componentResults = (ComponentResults)this.getResults(componentName);
        return componentResults.getSummaryScenarios(false, config);
    }

    public String[] getConfigBoxes(boolean sort) {
        return sort ? this.sortedConfigBoxes : this.configBoxes;
    }

    public String[] getConfigNames(boolean sort) {
        return sort ? this.sortedConfigNames : this.configNames;
    }

    String getConfigurationsPattern() {
        if (this.configPattern == null) {
            int length;
            int n = length = this.sortedConfigNames == null ? 0 : this.sortedConfigNames.length;
            if (length == 0) {
                return null;
            }
            this.configPattern = this.sortedConfigNames[0];
            int refLength = this.configPattern.length();
            int i = 1;
            while (i < length) {
                String config = this.sortedConfigNames[i];
                StringBuffer newConfig = null;
                if (refLength != config.length()) {
                    return null;
                }
                int j = 0;
                while (j < refLength) {
                    char c = this.configPattern.charAt(j);
                    if (config.charAt(j) != c) {
                        if (newConfig == null) {
                            newConfig = new StringBuffer(refLength);
                            if (j == 0) {
                                return null;
                            }
                            newConfig.append(this.configPattern.substring(0, j));
                        }
                        newConfig.append('_');
                    } else if (newConfig != null) {
                        newConfig.append(c);
                    }
                    ++j;
                }
                if (newConfig != null) {
                    this.configPattern = newConfig.toString();
                }
                ++i;
            }
        }
        return this.configPattern;
    }

    public String getLastBuildName() {
        return this.getLastBuildName(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getLastBuildName(int kind) {
        if (this.name != null) return this.name;
        this.getAllBuildNames();
        int idx = this.allBuildNames.length - 1;
        this.name = this.allBuildNames[idx];
        if (kind <= 0) return this.name;
        while (idx-- >= 0) {
            switch (this.name.charAt(0)) {
                case 'N': {
                    if (kind >= 2) break;
                    return this.name;
                }
                case 'M': {
                    if (kind >= 3) break;
                    return this.name;
                }
                case 'I': {
                    if (kind >= 4) break;
                    return this.name;
                }
            }
            this.name = this.allBuildNames[idx];
        }
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            this.setAllBuildNames();
        }
        return this.name;
    }

    PerformanceResults getPerformance() {
        return this;
    }

    public ScenarioResults getScenarioResults(String scenarioName) {
        ComponentResults componentResults = (ComponentResults)this.getResults(DB_Results.getComponentNameFromScenario(scenarioName));
        return componentResults == null ? null : (ScenarioResults)componentResults.getResults(scenarioName);
    }

    private String[] read(boolean local, String buildName, String[][] configs, boolean force, File dataDir, String taskName, SubMonitor subMonitor) {
        int allScenariosSize;
        boolean reset;
        if (local && dataDir == null) {
            throw new IllegalArgumentException("Must specify a directory to read local files!");
        }
        subMonitor.setWorkRemaining(100);
        boolean bl = reset = local || buildName == null && force;
        if (reset) {
            this.reset();
        }
        this.setConfigInfo(configs);
        long start = System.currentTimeMillis();
        try {
            allScenariosSize = this.readScenarios(buildName, subMonitor.newChild(10));
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        int componentsLength = this.components.length;
        subMonitor.setWorkRemaining(componentsLength);
        RemainingTimeGuess timeGuess = null;
        int i = 0;
        while (i < componentsLength) {
            String componentName = this.components[i];
            List scenarios = (List)this.allScenarios.get(componentName);
            int percentage = (int)((double)(i + 1) / (double)(componentsLength + 1) * 100.0);
            subMonitor.setTaskName(String.valueOf(taskName) + " (" + percentage + "%)");
            StringBuffer subTaskBuffer = new StringBuffer("Component ");
            subTaskBuffer.append(componentName);
            subTaskBuffer.append("...");
            subMonitor.subTask(subTaskBuffer.toString());
            if (scenarios != null) {
                ComponentResults componentResults;
                if (reset) {
                    componentResults = new ComponentResults((AbstractResults)this, componentName);
                    this.addChild(componentResults, true);
                } else {
                    componentResults = (ComponentResults)this.getResults(componentName);
                }
                if (local) {
                    try {
                        componentResults.readLocalFile(dataDir, scenarios);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                    subMonitor.worked(1);
                } else {
                    if (timeGuess == null) {
                        timeGuess = new RemainingTimeGuess(1 + componentsLength + allScenariosSize, start);
                    }
                    componentResults.updateBuild(buildName, scenarios, force, dataDir, subMonitor.newChild(1), timeGuess);
                }
                if (subMonitor.isCanceled()) {
                    return null;
                }
            }
            ++i;
        }
        this.setAllBuildNames();
        this.printGlobalTime(start);
        return this.allBuildNames;
    }

    public String[] readAll(String buildName, String[][] configs, String pattern, File dataDir, int threshold, IProgressMonitor monitor) {
        this.scenarioPattern = pattern == null ? "%" : pattern;
        this.failure_threshold = threshold;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        this.setDefaults();
        String[] names = this.read(true, null, configs, true, dataDir, null, subMonitor.newChild(100));
        if (names == null) {
            return this.read(false, null, configs, true, dataDir, null, subMonitor.newChild(900));
        }
        String[] builds = DB_Results.getBuilds();
        Arrays.sort(builds, new BuildDateComparator());
        int lengthDB = builds.length;
        int lengthLocal = names.length;
        if (lengthLocal < lengthDB) {
            int length = lengthDB - lengthLocal;
            String[] addedBuilds = new String[length];
            int idx = length - 1;
            int idxDB = lengthDB - 1;
            while (!this.allBuildNames[lengthLocal - 1].equals(builds[idxDB])) {
                addedBuilds[idx] = builds[idxDB];
                --idxDB;
                --idx;
            }
            int i = idx + 1;
            while (i < length) {
                this.read(false, addedBuilds[i], configs, true, dataDir, null, subMonitor.newChild(900));
                ++i;
            }
        }
        return this.allBuildNames;
    }

    public String[] readLocal(File dataDir, IProgressMonitor monitor) {
        String taskName = "Read local performance results";
        this.println(taskName);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.setTaskName(taskName);
        return this.read(true, null, null, true, dataDir, taskName, subMonitor);
    }

    private int readScenarios(String buildName, SubMonitor subMonitor) throws OperationCanceledException {
        subMonitor.setWorkRemaining(10);
        long start = System.currentTimeMillis();
        String titleSuffix = buildName == null ? "all database scenarios..." : "all database scenarios for " + buildName + " build...";
        this.print("\t+ get " + titleSuffix);
        subMonitor.subTask("Get " + titleSuffix);
        this.allScenarios = DB_Results.queryAllScenarios(this.scenarioPattern, buildName);
        int allScenariosSize = 0;
        ArrayList componentsSet = new ArrayList(this.allScenarios.keySet());
        Collections.sort(componentsSet);
        int componentsSize = componentsSet.size();
        this.components = new String[componentsSize];
        componentsSet.toArray(this.components);
        int i = 0;
        while (i < componentsSize) {
            String componentName = this.components[i];
            List scenarios = (List)this.allScenarios.get(componentName);
            allScenariosSize += scenarios.size();
            ++i;
        }
        this.println(" -> " + allScenariosSize + " found in " + (System.currentTimeMillis() - start) + "ms");
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return allScenariosSize;
    }

    private void reset() {
        this.allBuildNames = null;
        this.children = new ArrayList();
        this.name = null;
        this.components = null;
    }

    private void setAllBuildNames() {
        TreeSet builds = new TreeSet(new BuildDateComparator());
        int size = this.size();
        int i = 0;
        while (i < size) {
            ComponentResults componentResults = (ComponentResults)this.children.get(i);
            Set names = componentResults.getAllBuildNames();
            builds.addAll(names);
            ++i;
        }
        int buildsSize = builds.size();
        this.allBuildNames = new String[buildsSize];
        if (buildsSize > 0) {
            builds.toArray(this.allBuildNames);
            int idx = this.allBuildNames.length - 1;
            this.name = this.allBuildNames[idx--];
            while (this.name.startsWith(VERSION_REF)) {
                this.name = this.allBuildNames[idx--];
            }
        }
    }

    private void setConfigInfo(String[][] configs) {
        int i;
        int length;
        if (configs == null) {
            length = CONFIGS.length;
            this.configNames = new String[length];
            this.sortedConfigNames = new String[length];
            this.configBoxes = new String[length];
            i = 0;
            while (i < length) {
                this.configNames[i] = this.sortedConfigNames[i] = CONFIGS[i];
                this.configBoxes[i] = BOXES[i];
                ++i;
            }
        } else {
            length = configs.length;
            this.configNames = new String[length];
            this.sortedConfigNames = new String[length];
            this.configBoxes = new String[length];
            i = 0;
            while (i < length) {
                this.configNames[i] = this.sortedConfigNames[i] = configs[i][0];
                this.configBoxes[i] = configs[i][1];
                ++i;
            }
        }
        Arrays.sort(this.sortedConfigNames);
        length = this.sortedConfigNames.length;
        this.sortedConfigBoxes = new String[length];
        i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                if (this.sortedConfigNames[i] == this.configNames[j]) {
                    this.sortedConfigBoxes[i] = this.configBoxes[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setDefaults() {
        if (this.name == null) {
            this.setAllBuildNames();
            if (this.name == null) {
                this.name = DB_Results.getLastCurrentBuild();
                if (this.name == null) {
                    throw new RuntimeException("Cannot find any current build!");
                }
                if (this.printStream != null) {
                    this.printStream.println("\t+ no build specified => use last one: " + this.name);
                }
            }
        }
        if (this.baselineName == null) {
            String buildDate = AbstractResults.getBuildDate(this.getName());
            this.baselineName = DB_Results.getLastBaselineBuild(buildDate);
            if (this.baselineName == null) {
                throw new RuntimeException("Cannot find any baseline to refer!");
            }
            if (this.printStream != null) {
                this.printStream.println("\t+ no baseline specified => use last one: " + this.baselineName);
            }
        }
        if (this.baselinePrefix == null) {
            this.baselinePrefix = this.baselineName.substring(0, this.baselineName.lastIndexOf(95));
        }
        if (this.scenarioPattern == null) {
            this.scenarioPattern = "%";
        }
        if (this.printStream != null) {
            this.printStream.println();
            this.printStream.flush();
        }
    }

    public String[] updateBuilds(String[] builds, boolean force, File dataDir, IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer("Update data for ");
        int length = builds == null ? 0 : builds.length;
        switch (length) {
            case 0: {
                buffer.append("all builds");
                this.reset();
                break;
            }
            case 1: {
                buffer.append(builds[0]);
                buffer.append(" build");
                break;
            }
            default: {
                buffer.append("several builds");
            }
        }
        String taskName = buffer.toString();
        this.println(buffer);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1000 * length));
        subMonitor.setTaskName(taskName);
        int i = 0;
        while (i < length) {
            this.read(false, builds[i], null, force, dataDir, taskName, subMonitor.newChild(1000));
            ++i;
        }
        return this.allBuildNames;
    }

    public String[] updateBuild(String buildName, boolean force, File dataDir, IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer("Update data for ");
        if (buildName == null) {
            buffer.append("all builds");
            this.reset();
        } else {
            buffer.append(buildName);
            buffer.append(" build");
        }
        String taskName = buffer.toString();
        this.println(buffer);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.setTaskName(taskName);
        this.read(false, buildName, null, force, dataDir, taskName, subMonitor);
        if (buildName != null && !buildName.startsWith(VERSION_REF)) {
            this.name = buildName;
        }
        return this.allBuildNames;
    }

    private final class BuildDateComparator
    implements Comparator {
        private BuildDateComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return PerformanceResults.getBuildDate(s1).compareTo(PerformanceResults.getBuildDate(s2));
        }
    }

    class RemainingTimeGuess {
        int all;
        int count;
        long start;
        double remaining;

        RemainingTimeGuess(int all, long start) {
            this.all = all;
            this.start = start;
        }

        String display() {
            StringBuffer buffer = new StringBuffer(" [elapsed: ");
            long elapsed = this.getElapsed();
            buffer.append(PerformanceResults.timeChrono(elapsed));
            if (this.count > 0) {
                buffer.append(" | left: ");
                long remainingTime = this.getRemainingTime(elapsed);
                buffer.append(PerformanceResults.timeChrono(remainingTime));
                buffer.append(" | end: ");
                buffer.append(PerformanceResults.timeEnd(remainingTime));
            }
            buffer.append(']');
            return buffer.toString();
        }

        private long getRemainingTime(long elapsed) {
            return (long)((double)elapsed / (double)this.count * (double)(this.all - this.count));
        }

        private long getElapsed() {
            return System.currentTimeMillis() - this.start;
        }
    }
}

