/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.SQL_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class DB_Results {
    private static final String[] EMPTY_LIST = new String[0];
    static final boolean DEBUG = false;
    static final boolean LOG = false;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB_Results fgDefault;
    private Connection fConnection;
    private SQL_Results fSQL;
    private String fDBType;
    static final StringWriter DEBUG_STR_WRITER;
    static final PrintWriter DEBUG_WRITER;
    static final StringWriter LOG_STR_WRITER;
    static final LogWriter LOG_WRITER;
    private static String[] CONFIGS;
    private static String[] COMPONENTS;
    private static String[] BUILDS;
    static String LAST_CURRENT_BUILD;
    static String LAST_BASELINE_BUILD;
    private static int BUILDS_LENGTH;
    private static String[] SCENARII;
    private static String[] COMMENTS;
    private static final int MAX_CONFIGS = 5;
    private static final String[] SUPPORTED_VMS;
    private static final String[] SUPPORTED_COMPONENTS;

    static {
        DEBUG_STR_WRITER = null;
        DEBUG_WRITER = null;
        LOG_STR_WRITER = new StringWriter();
        LOG_WRITER = new LogWriter();
        SUPPORTED_VMS = new String[]{"sun"};
        SUPPORTED_COMPONENTS = new String[]{"org.eclipse.ant", "org.eclipse.compare", "org.eclipse.core", "org.eclipse.help", "org.eclipse.jdt.core", "org.eclipse.jdt.debug", "org.eclipse.jdt.text", "org.eclipse.jdt.ui", "org.eclipse.jface", "org.eclipse.osgi", "org.eclipse.pde.api.tools", "org.eclipse.pde.ui", "org.eclipse.swt", "org.eclipse.team", "org.eclipse.ua", "org.eclipse.ui"};
    }

    private DB_Results() {
    }

    static synchronized DB_Results getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB_Results();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        DB_Results.shutdown();
                    }
                });
            }
        } else if (DB_Results.fgDefault.fSQL == null) {
            fgDefault.connect();
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    static int getBuildId(String name) {
        if (BUILDS == null) {
            return -1;
        }
        return Arrays.binarySearch(BUILDS, name);
    }

    static String getBuildName(int id) {
        if (BUILDS == null) {
            return null;
        }
        return BUILDS[id];
    }

    public static String[] getBuilds() {
        if (BUILDS == null) {
            DB_Results.queryAllVariations("%");
        }
        if (BUILDS_LENGTH == 0) {
            return EMPTY_LIST;
        }
        String[] builds = new String[BUILDS_LENGTH];
        System.arraycopy(BUILDS, 0, builds, 0, BUILDS_LENGTH);
        return builds;
    }

    static String getComponentNameFromScenario(String scenarioName) {
        int length = SUPPORTED_COMPONENTS.length;
        int i = 0;
        while (i < length) {
            if (scenarioName.startsWith(SUPPORTED_COMPONENTS[i])) {
                return SUPPORTED_COMPONENTS[i];
            }
            ++i;
        }
        System.err.println("Not able to find a supported component for scenario " + scenarioName);
        return null;
    }

    public static String[] getComponents() {
        if (COMPONENTS == null) {
            return EMPTY_LIST;
        }
        int length = COMPONENTS.length;
        String[] components = new String[length];
        System.arraycopy(COMPONENTS, 0, components, 0, length);
        return components;
    }

    static String getConfig(int id) {
        return CONFIGS[id];
    }

    public static String getLastBaselineBuild(String date) {
        if (BUILDS == null) {
            DB_Results.queryAllVariations("%");
        }
        if (date == null) {
            return LAST_BASELINE_BUILD;
        }
        String lastBaselineBuild = null;
        int i = 0;
        while (i < BUILDS_LENGTH) {
            String buildDate;
            String build = BUILDS[i];
            if (build.startsWith(AbstractResults.VERSION_REF) && (buildDate = build.substring(build.indexOf(95) + 1)).compareTo(date) < 0 && (lastBaselineBuild == null || build.compareTo(lastBaselineBuild) > 0)) {
                lastBaselineBuild = build;
            }
            ++i;
        }
        return lastBaselineBuild;
    }

    public static String getLastCurrentBuild() {
        if (BUILDS == null) {
            DB_Results.queryAllVariations("%");
        }
        return LAST_CURRENT_BUILD;
    }

    public static List getScenarios() {
        return Arrays.asList(SCENARII);
    }

    public static Map queryAllScenarios() {
        return DB_Results.getDefault().internalQueryBuildScenarios("%", null);
    }

    static Map queryAllScenarios(String scenarioPattern) {
        String pattern = scenarioPattern == null ? "%" : scenarioPattern;
        return DB_Results.getDefault().internalQueryBuildScenarios(pattern, null);
    }

    static Map queryAllScenarios(String scenarioPattern, String buildName) {
        return DB_Results.getDefault().internalQueryBuildScenarios(scenarioPattern, buildName);
    }

    static void queryAllVariations(String configPattern) {
        DB_Results.getDefault().internalQueryAllVariations(configPattern);
    }

    static void queryScenarioSummaries(ScenarioResults scenarioResults, String configPattern, String[] builds) {
        DB_Results.getDefault().internalQueryScenarioSummaries(scenarioResults, configPattern, builds);
    }

    static void queryScenarioValues(ScenarioResults scenarioResults, String configPattern, String buildName) {
        DB_Results.getDefault().internalQueryScenarioValues(scenarioResults, configPattern, buildName);
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else if (dbloc.startsWith("//")) {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL_Results(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        if (this.fSQL != null) {
            try {
                this.fSQL.dispose();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
            this.fSQL = null;
        }
        if (this.fConnection != null) {
            try {
                this.fConnection.commit();
            }
            catch (SQLException e) {
                PerformanceTestPlugin.log(e);
            }
            try {
                this.fConnection.close();
            }
            catch (SQLException e) {
                PerformanceTestPlugin.log(e);
            }
            this.fConnection = null;
        }
    }

    private int getConfigId(String config) {
        if (CONFIGS == null) {
            return -1;
        }
        return Arrays.binarySearch(CONFIGS, config);
    }

    SQL_Results getSQL() {
        return this.fSQL;
    }

    private void internalQueryAllComments() {
        block20: {
            if (this.fSQL == null) {
                return;
            }
            if (COMMENTS != null) {
                return;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    String[] comments = null;
                    result = this.fSQL.queryAllComments();
                    while (result.next()) {
                        int commentID = result.getInt(1);
                        String comment = result.getString(3);
                        if (comments == null) {
                            comments = new String[commentID + 10];
                        } else if (commentID >= comments.length) {
                            int length = comments.length;
                            String[] stringArray = comments;
                            comments = new String[commentID + 10];
                            System.arraycopy(stringArray, 0, comments, 0, length);
                        }
                        comments[commentID] = comment;
                    }
                    COMMENTS = comments;
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void internalQueryAllVariations(String configPattern) {
        block21: {
            if (this.fSQL == null) {
                return;
            }
            if (BUILDS != null) {
                return;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    CONFIGS = new String[5];
                    BUILDS = null;
                    BUILDS_LENGTH = 0;
                    result = this.fSQL.queryAllVariations(configPattern);
                    while (result.next()) {
                        String variation = result.getString(1);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        tokenizer.nextToken();
                        this.storeConfig(tokenizer.nextToken());
                        tokenizer.nextToken();
                        String vmName = tokenizer.nextToken();
                        if (!vmName.equals(SUPPORTED_VMS[0])) continue;
                        this.storeBuildName(buildName);
                    }
                    if (BUILDS_LENGTH == 0) {
                        BUILDS = EMPTY_LIST;
                    } else {
                        String[] stringArray = BUILDS;
                        BUILDS = new String[BUILDS_LENGTH];
                        System.arraycopy(stringArray, 0, BUILDS, 0, BUILDS_LENGTH);
                    }
                    int i = 0;
                    while (i < 5) {
                        if (CONFIGS[i] == null) {
                            String[] stringArray = CONFIGS;
                            CONFIGS = new String[i];
                            System.arraycopy(stringArray, 0, CONFIGS, 0, i);
                            break;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Map internalQueryBuildScenarios(String scenarioPattern, String buildName) {
        HashMap allScenarios;
        block17: {
            if (this.fSQL == null) {
                return null;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            allScenarios = new HashMap();
            try {
                try {
                    result = buildName == null ? this.fSQL.queryBuildAllScenarios(scenarioPattern) : this.fSQL.queryBuildScenarios(scenarioPattern, buildName);
                    int previousId = -1;
                    ArrayList<ScenarioResults> scenarios = null;
                    ArrayList<String> scenariosNames = new ArrayList<String>();
                    int i = 0;
                    while (result.next()) {
                        int id = result.getInt(1);
                        String name = result.getString(2);
                        scenariosNames.add(name);
                        String shortName = result.getString(3);
                        int component_id = this.storeComponent(DB_Results.getComponentNameFromScenario(name));
                        if (component_id != previousId) {
                            scenarios = new ArrayList<ScenarioResults>();
                            allScenarios.put(COMPONENTS[component_id], scenarios);
                            previousId = component_id;
                        }
                        scenarios.add(new ScenarioResults(id, name, shortName));
                        ++i;
                    }
                    SCENARII = new String[scenariosNames.size()];
                    scenariosNames.toArray(SCENARII);
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return allScenarios;
    }

    private void internalQueryScenarioValues(ScenarioResults scenarioResults, String configPattern, String buildName) {
        block18: {
            if (this.fSQL == null) {
                return;
            }
            this.internalQueryAllVariations(configPattern);
            ResultSet result = null;
            try {
                try {
                    int count = 0;
                    result = buildName == null ? this.fSQL.queryScenarioDataPoints(configPattern, scenarioResults.getId()) : this.fSQL.queryScenarioBuildDataPoints(configPattern, scenarioResults.getId(), buildName);
                    while (result.next()) {
                        int dp_id = result.getInt(1);
                        int step = result.getInt(2);
                        String variation = result.getString(3);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        int build_id = DB_Results.getBuildId(tokenizer.nextToken());
                        tokenizer.nextToken();
                        int config_id = this.getConfigId(tokenizer.nextToken());
                        ResultSet rs2 = this.fSQL.queryDimScalars(dp_id);
                        while (rs2.next()) {
                            int dim_id = rs2.getInt(1);
                            BigDecimal decimalValue = rs2.getBigDecimal(2);
                            long value = decimalValue.longValue();
                            if (build_id >= 0) {
                                scenarioResults.setValue(build_id, dim_id, config_id, step, value);
                            }
                            ++count;
                        }
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void internalQueryScenarioSummaries(ScenarioResults scenarioResults, String config, String[] builds) {
        block16: {
            if (this.fSQL == null) {
                return;
            }
            System.currentTimeMillis();
            this.internalQueryAllComments();
            ResultSet result = null;
            try {
                try {
                    int scenarioID = scenarioResults.getId();
                    result = this.fSQL.queryScenarioSummaries(scenarioID, config, builds);
                    while (result.next()) {
                        String variation = result.getString(1);
                        short summaryKind = result.getShort(2);
                        int comment_id = result.getInt(3);
                        int dim_id = result.getInt(4);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        tokenizer.nextToken();
                        int config_id = this.getConfigId(tokenizer.nextToken());
                        int build_id = DB_Results.getBuildId(buildName);
                        if (build_id < 0) continue;
                        scenarioResults.setInfos(config_id, build_id, dim_id == 0 ? -1 : (int)summaryKind, COMMENTS[comment_id]);
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private int storeComponent(String component) {
        if (COMPONENTS == null) {
            COMPONENTS = new String[1];
            DB_Results.COMPONENTS[0] = component;
            return 0;
        }
        int idx = Arrays.binarySearch(COMPONENTS, component);
        if (idx >= 0) {
            return idx;
        }
        int length = COMPONENTS.length;
        String[] stringArray = COMPONENTS;
        COMPONENTS = new String[length + 1];
        System.arraycopy(stringArray, 0, COMPONENTS, 0, length);
        DB_Results.COMPONENTS[length] = component;
        return length;
    }

    private int storeBuildName(String build) {
        boolean isVersion = build.startsWith("R-");
        if (BUILDS == null) {
            BUILDS = new String[1];
            DB_Results.BUILDS[DB_Results.BUILDS_LENGTH++] = build;
            if (isVersion) {
                LAST_BASELINE_BUILD = build;
            } else {
                LAST_CURRENT_BUILD = build;
            }
            return 0;
        }
        int idx = Arrays.binarySearch(BUILDS, build);
        if (idx >= 0) {
            return idx;
        }
        int index = -idx - 1;
        int length = BUILDS.length;
        if (BUILDS_LENGTH == length) {
            String[] array = new String[length + 1];
            if (index > 0) {
                System.arraycopy(BUILDS, 0, array, 0, index);
            }
            array[index] = build;
            if (index < length) {
                System.arraycopy(BUILDS, index, array, index + 1, length - index);
            }
            BUILDS = array;
        } else if (index < length) {
            System.arraycopy(BUILDS, index, BUILDS, index + 1, length - index);
            DB_Results.BUILDS[index] = build;
        }
        ++BUILDS_LENGTH;
        if (isVersion) {
            if (LAST_BASELINE_BUILD == null || LAST_CURRENT_BUILD == null) {
                LAST_BASELINE_BUILD = build;
            } else {
                String buildDate = String.valueOf(LAST_CURRENT_BUILD.substring(1, 9)) + LAST_CURRENT_BUILD.substring(10, LAST_CURRENT_BUILD.length());
                String baselineDate = LAST_BASELINE_BUILD.substring(LAST_BASELINE_BUILD.indexOf(95) + 1);
                if (build.compareTo(LAST_BASELINE_BUILD) > 0 && baselineDate.compareTo(buildDate) < 0) {
                    LAST_BASELINE_BUILD = build;
                }
            }
        } else if (LAST_CURRENT_BUILD == null || build.substring(1).compareTo(LAST_CURRENT_BUILD.substring(1)) >= 0) {
            LAST_CURRENT_BUILD = build;
        }
        return index;
    }

    private int storeConfig(String config) {
        int i = 0;
        while (i < 5) {
            if (CONFIGS[i] == null) {
                DB_Results.CONFIGS[i] = config;
                return i;
            }
            if (config.equals(CONFIGS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class LogWriter
    extends PrintWriter {
        long[] starts = new long[10];
        long[] times = new long[10];
        StringBuffer[] buffers = new StringBuffer[10];
        int depth = -1;
        int max = -1;

        public LogWriter() {
            super(LOG_STR_WRITER);
        }

        void starts(String log) {
            if (++this.depth >= this.buffers.length) {
                this.times = new long[this.depth + 10];
                System.arraycopy(this.times, 0, this.times, 0, this.depth);
                this.buffers = new StringBuffer[this.depth + 10];
                System.arraycopy(this.buffers, 0, this.buffers, 0, this.depth);
            }
            StringBuffer buffer = this.buffers[this.depth];
            if (this.buffers[this.depth] == null) {
                buffer = this.buffers[this.depth] = new StringBuffer();
            }
            buffer.append(log);
            this.starts[this.depth] = System.currentTimeMillis();
            if (this.depth > this.max) {
                this.max = this.depth;
            }
        }

        void ends(String log) {
            if (this.depth < 0) {
                throw new RuntimeException("Invalid call to ends (missing corresponding starts call)!");
            }
            this.buffers[this.depth].append(log);
            if (this.depth > 0) {
                int n = this.depth;
                this.times[n] = this.times[n] + (System.currentTimeMillis() - this.starts[this.depth]);
                --this.depth;
                return;
            }
            int i = 0;
            while (i < this.max) {
                this.print(this.buffers[i].toString());
                this.print(" ( in ");
                this.print(this.times[this.depth]);
                this.println("ms)");
                ++i;
            }
            this.max = -1;
            this.depth = -1;
            this.starts = new long[10];
            this.times = new long[10];
            this.buffers = new StringBuffer[10];
        }

        public String toString() {
            return LOG_STR_WRITER.toString();
        }
    }
}

