/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.PerformanceResults;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class ConfigResults
extends AbstractResults {
    BuildResults baseline;
    BuildResults current;
    boolean baselined = false;
    boolean valid = false;
    double delta;
    double error;

    public ConfigResults(AbstractResults parent, int id) {
        super(parent, id);
        this.name = parent.getPerformance().sortedConfigNames[id];
        this.printStream = parent.printStream;
    }

    void completeResults(String[] builds) {
        this.initialize();
        ScenarioResults scenarioResults = (ScenarioResults)this.parent;
        DB_Results.queryScenarioSummaries(scenarioResults, this.name, builds);
    }

    public String getBaselineBuildName() {
        if (this.baseline == null) {
            this.initialize();
        }
        return this.baseline.getName();
    }

    public BuildResults getBaselineBuildResults() {
        if (this.baseline == null) {
            this.initialize();
        }
        return this.baseline;
    }

    public BuildResults getBaselineBuildResults(String buildName) {
        if (this.baseline == null) {
            this.initialize();
        }
        int size = this.children.size();
        String buildDate = ConfigResults.getBuildDate(buildName);
        int i = size - 1;
        while (i >= 0) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (buildResults.isBaseline() && buildResults.getDate().compareTo(buildDate) < 0) {
                return buildResults;
            }
            --i;
        }
        return this.baseline;
    }

    public double getBaselineBuildValue() {
        if (this.baseline == null) {
            this.initialize();
        }
        return this.baseline.getValue();
    }

    public String getDescription() {
        return this.getPerformance().sortedConfigBoxes[this.id];
    }

    public BuildResults getBuildResults(String buildName) {
        return (BuildResults)this.getResults(buildName);
    }

    public List getBuilds(String buildPattern) {
        ArrayList<BuildResults> builds = new ArrayList<BuildResults>();
        int size = this.size();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (buildPattern == null || buildResults.match(buildPattern)) {
                builds.add(buildResults);
            }
            ++i;
        }
        return builds;
    }

    public List getBuildsMatchingPrefixes(List prefixes) {
        ArrayList<AbstractResults> builds = new ArrayList<AbstractResults>();
        int size = this.size();
        int length = prefixes.size();
        int i = 0;
        while (i < size) {
            AbstractResults buildResults = (AbstractResults)this.children.get(i);
            String buildName = buildResults.getName();
            int j = 0;
            while (j < length) {
                if (buildName.startsWith((String)prefixes.get(j))) {
                    builds.add(buildResults);
                }
                ++j;
            }
            ++i;
        }
        return builds;
    }

    public double[] getCurrentBuildDeltaInfo() {
        if (this.baseline == null || this.current == null) {
            this.initialize();
        }
        return new double[]{this.delta, this.error};
    }

    public double getCurrentBuildError() {
        if (this.current == null) {
            this.initialize();
        }
        return this.current.getError();
    }

    public String getCurrentBuildName() {
        if (this.current == null) {
            this.initialize();
        }
        return this.current.getName();
    }

    public BuildResults getCurrentBuildResults() {
        if (this.current == null) {
            this.initialize();
        }
        return this.current;
    }

    public double getCurrentBuildValue() {
        if (this.current == null) {
            this.initialize();
        }
        return this.current.getValue();
    }

    public double getDelta() {
        if (this.baseline == null || this.current == null) {
            this.initialize();
        }
        return this.delta;
    }

    public double getError() {
        if (this.baseline == null || this.current == null) {
            this.initialize();
        }
        return this.error;
    }

    public double[] getStatistics(List prefixes) {
        return this.getStatistics(prefixes, DEFAULT_DIM.getId());
    }

    public double[] getStatistics(List prefixes, int dim_id) {
        int size = this.size();
        int length = prefixes == null ? 0 : prefixes.size();
        int count = 0;
        double mean = 0.0;
        double stddev = 0.0;
        double variation = 0.0;
        double[] values = new double[size];
        count = 0;
        mean = 0.0;
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            String buildName = buildResults.getName();
            if (this.isBuildConcerned(buildResults)) {
                if (prefixes == null) {
                    double value;
                    values[count] = value = buildResults.getValue(dim_id);
                    mean += value;
                    ++count;
                } else {
                    int j = 0;
                    while (j < length) {
                        if (buildName.startsWith((String)prefixes.get(j))) {
                            double value;
                            values[count] = value = buildResults.getValue(dim_id);
                            mean += value;
                            ++count;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        mean /= (double)count;
        i = 0;
        while (i < count) {
            stddev += Math.pow(values[i] - mean, 2.0);
            ++i;
        }
        stddev = Math.sqrt(stddev / (double)(count - 1));
        variation = Math.round(stddev / mean * 100.0 * 100.0) / 100L;
        return new double[]{count, mean, stddev, variation};
    }

    private void initialize() {
        this.reset();
        PerformanceResults perfResults = this.getPerformance();
        String baselineBuildName = perfResults.getBaselineName();
        String baselineBuildDate = baselineBuildName == null ? null : ConfigResults.getBuildDate(baselineBuildName);
        String currentBuildName = perfResults.name;
        String currentBuildDate = currentBuildName == null ? null : ConfigResults.getBuildDate(currentBuildName);
        BuildResults lastBaseline = null;
        int size = this.size();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (buildResults.values != null) {
                buildResults.cleanValues();
            }
            if (buildResults.isBaseline()) {
                if (lastBaseline == null || baselineBuildDate == null || baselineBuildDate.compareTo(buildResults.getDate()) >= 0) {
                    lastBaseline = buildResults;
                }
                if (baselineBuildName != null && buildResults.getName().equals(baselineBuildName)) {
                    this.baseline = buildResults;
                    this.baselined = true;
                }
            } else if (currentBuildName == null || currentBuildDate == null || buildResults.getDate().compareTo(currentBuildDate) >= 0) {
                this.current = buildResults;
                this.valid = true;
            }
            ++i;
        }
        if (this.baseline == null) {
            BuildResults buildResults = this.baseline = lastBaseline == null ? (BuildResults)this.children.get(0) : lastBaseline;
        }
        if (this.current == null) {
            int idx = this.size() - 1;
            BuildResults previous = (BuildResults)this.children.get(idx--);
            while (idx >= 0 && previous.isBaseline()) {
                previous = (BuildResults)this.children.get(idx--);
            }
            this.current = previous;
        }
        int dim_id = DEFAULT_DIM.getId();
        double baselineValue = this.baseline.getValue();
        double currentValue = this.current.getValue();
        this.delta = (currentValue - baselineValue) / baselineValue;
        if (Double.isNaN(this.delta)) {
            this.error = Double.NaN;
        } else {
            long baselineCount = this.baseline.getCount(dim_id);
            long currentCount = this.current.getCount(dim_id);
            if (baselineCount == 1L || currentCount == 1L) {
                this.error = Double.NaN;
            } else {
                double baselineError = this.baseline.getError(dim_id);
                double currentError = this.current.getError(dim_id);
                this.error = Double.isNaN(baselineError) ? currentError / baselineValue : Math.sqrt(baselineError * baselineError + currentError * currentError) / baselineValue;
            }
        }
        int failure_threshold = this.getPerformance().failure_threshold;
        if (this.delta >= (double)failure_threshold / 100.0) {
            StringBuffer buffer = new StringBuffer("Performance criteria not met when compared to '");
            buffer.append(this.baseline.getName());
            buffer.append("': ");
            buffer.append(DEFAULT_DIM.getName());
            buffer.append("= ");
            buffer.append(ConfigResults.timeString((long)this.current.getValue()));
            buffer.append(" is not within [0%, ");
            buffer.append(100 + failure_threshold);
            buffer.append("'%] of ");
            buffer.append(ConfigResults.timeString((long)this.baseline.getValue()));
            this.current.setFailure(buffer.toString());
        }
    }

    public boolean isBaselined() {
        if (this.baseline == null || this.current == null) {
            this.initialize();
        }
        return this.baselined;
    }

    boolean isBuildConcerned(BuildResults buildResults) {
        String baselineBuildDate;
        String buildDate = buildResults.getDate();
        String currentBuildDate = this.getCurrentBuildResults() == null ? null : this.getCurrentBuildResults().getDate();
        String string = baselineBuildDate = this.getBaselineBuildResults() == null ? null : this.getBaselineBuildResults().getDate();
        return !(currentBuildDate != null && buildDate.compareTo(currentBuildDate) > 0 || baselineBuildDate != null && buildDate.compareTo(baselineBuildDate) > 0);
    }

    public boolean isValid() {
        if (this.baseline == null || this.current == null) {
            this.initialize();
        }
        return this.valid;
    }

    public List lastNightlyBuildNames(int n) {
        ArrayList<String> labels = new ArrayList<String>();
        int i = this.size() - 2;
        while (i >= 0) {
            String buildName;
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (this.isBuildConcerned(buildResults) && (buildName = buildResults.getName()).startsWith("N")) {
                labels.add(buildName);
                if (labels.size() >= n) break;
            }
            --i;
        }
        return labels;
    }

    void readData(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = new BuildResults(this);
            buildResults.readData(stream);
            this.addChild(buildResults, true);
            ++i;
        }
    }

    private void reset() {
        this.current = null;
        this.baseline = null;
        this.baselined = false;
        this.valid = false;
        this.delta = 0.0;
        this.error = -1.0;
    }

    void setInfos(int build_id, int summaryKind, String comment) {
        BuildResults buildResults = (BuildResults)this.getResults(build_id);
        if (buildResults == null) {
            buildResults = new BuildResults((AbstractResults)this, build_id);
            this.addChild(buildResults, true);
        }
        buildResults.summaryKind = summaryKind;
        buildResults.comment = comment;
    }

    void setValue(int build_id, int dim_id, int step, long value) {
        BuildResults buildResults = (BuildResults)this.getResults(build_id);
        if (buildResults == null) {
            buildResults = new BuildResults((AbstractResults)this, build_id);
            this.addChild(buildResults, true);
        }
        buildResults.setValue(dim_id, step, value);
    }

    void write(DataOutputStream stream) throws IOException {
        int size = this.size();
        stream.writeInt(this.id);
        stream.writeInt(size);
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            buildResults.write(stream);
            ++i;
        }
    }
}

