/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.ConfigResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.PerformanceResults;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class ComponentResults
extends AbstractResults {
    public ComponentResults(AbstractResults parent, String name) {
        super(parent, name);
        this.printStream = parent.printStream;
    }

    Set getAllBuildNames() {
        HashSet buildNames = new HashSet();
        int size = this.size();
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)this.children.get(i);
            Set builds = scenarioResults.getAllBuildNames();
            buildNames.addAll(builds);
            ++i;
        }
        return buildNames;
    }

    String[] getAllSortedBuildNames() {
        Set allBuildNames = this.getAllBuildNames();
        String[] sortedNames = new String[allBuildNames.size()];
        allBuildNames.toArray(sortedNames);
        Arrays.sort(sortedNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return ComponentResults.getBuildDate(s1).compareTo(ComponentResults.getBuildDate(s2));
            }
        });
        return sortedNames;
    }

    ComponentResults getComponentResults() {
        return this;
    }

    private ScenarioResults getScenarioResults(List scenarios, int searchedId) {
        int size = scenarios.size();
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)scenarios.get(i);
            if (scenarioResults.id == searchedId) {
                return scenarioResults;
            }
            ++i;
        }
        return null;
    }

    public List getSummaryScenarios(boolean global, String config) {
        int size = this.size();
        ArrayList<ScenarioResults> scenarios = new ArrayList<ScenarioResults>(size);
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)this.children.get(i);
            ConfigResults configResults = scenarioResults.getConfigResults(config);
            if (configResults != null) {
                BuildResults buildResults = configResults.getCurrentBuildResults();
                if (global && buildResults.summaryKind == 1 || !global && buildResults.summaryKind >= 0) {
                    scenarios.add(scenarioResults);
                }
            }
            ++i;
        }
        return scenarios;
    }

    private String lastBuildName(int kind) {
        String[] builds = this.getAllSortedBuildNames();
        int idx = builds.length - 1;
        String lastBuildName = builds[idx--];
        switch (kind) {
            case 1: {
                while (lastBuildName.startsWith(VERSION_REF)) {
                    lastBuildName = builds[idx--];
                }
                break;
            }
            case 2: {
                char ch = lastBuildName.charAt(0);
                while (ch != 'I' && ch != 'M') {
                    lastBuildName = builds[idx--];
                    ch = lastBuildName.charAt(0);
                }
                break;
            }
        }
        return lastBuildName;
    }

    /*
     * Loose catch block
     */
    String readLocalFile(File dir, List scenarios) throws FileNotFoundException {
        if (!dir.exists()) {
            return null;
        }
        File dataFile = new File(dir, String.valueOf(this.getName()) + ".dat");
        if (!dataFile.exists()) {
            throw new FileNotFoundException();
        }
        FilterInputStream stream = null;
        stream = new DataInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
        this.print(" - read local files info");
        String lastBuildName = ((DataInputStream)stream).readUTF();
        int size = ((DataInputStream)stream).readInt();
        int i = 0;
        while (i < size) {
            int scenario_id = ((DataInputStream)stream).readInt();
            ScenarioResults scenarioResults = this.getScenarioResults(scenarios, scenario_id);
            if (scenarioResults == null) {
                throw new RuntimeException("Unexpected unfound scenario!");
            }
            scenarioResults.parent = this;
            scenarioResults.printStream = this.printStream;
            scenarioResults.readData((DataInputStream)stream);
            this.addChild(scenarioResults, true);
            if (this.printStream != null) {
                this.printStream.print('.');
            }
            ++i;
        }
        this.println();
        this.println("\t=> " + size + " scenarios data were read from file " + dataFile);
        String string = lastBuildName;
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                this.println("\t!!! " + dataFile + " should be deleted as it contained invalid data !!!");
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    void updateBuild(String buildName, List scenarios, boolean force, File dataDir, SubMonitor subMonitor, PerformanceResults.RemainingTimeGuess timeGuess) {
        this.println("Component '" + this.name + "':");
        PerformanceResults performanceResults = this.getPerformance();
        DB_Results.queryAllVariations(performanceResults.getConfigurationsPattern());
        int size = scenarios.size();
        subMonitor.setWorkRemaining(size + 1);
        StringBuffer buffer = new StringBuffer("Component ");
        buffer.append(this.name);
        buffer.append("...");
        String title = buffer.toString();
        subMonitor.subTask(String.valueOf(title) + timeGuess.display());
        ++timeGuess.count;
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            return;
        }
        boolean dirty = false;
        long readTime = System.currentTimeMillis();
        String log = " - read scenarios from DB:";
        if (size > 0) {
            int i = 0;
            while (i < size) {
                subMonitor.subTask(String.valueOf(title) + timeGuess.display());
                ++timeGuess.count;
                if (log != null) {
                    this.println(log);
                    log = null;
                }
                ScenarioResults nextScenarioResults = (ScenarioResults)scenarios.get(i);
                ScenarioResults scenarioResults = (ScenarioResults)this.getResults(nextScenarioResults.id);
                if (scenarioResults == null) {
                    scenarioResults = nextScenarioResults;
                    scenarioResults.parent = this;
                    scenarioResults.printStream = this.printStream;
                    scenarioResults.updateBuild(buildName, true);
                    dirty = true;
                    this.addChild(scenarioResults, true);
                } else if (scenarioResults.updateBuild(buildName, force)) {
                    dirty = true;
                }
                if (dataDir != null && dirty && System.currentTimeMillis() - readTime > 300000L) {
                    this.writeData(buildName, dataDir, true, true);
                    dirty = false;
                    readTime = System.currentTimeMillis();
                }
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    return;
                }
                ++i;
            }
        }
        if (dataDir != null) {
            this.writeData(buildName, dataDir, false, dirty);
        }
        this.printGlobalTime(readTime);
    }

    void writeData(String buildName, File dir, boolean temp, boolean dirty) {
        File file;
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("can't create directory " + dir);
        }
        File tmpFile = new File(dir, String.valueOf(this.getName()) + ".tmp");
        File dataFile = new File(dir, String.valueOf(this.getName()) + ".dat");
        if (!dirty) {
            if (tmpFile.exists()) {
                if (dataFile.exists()) {
                    dataFile.delete();
                }
                tmpFile.renameTo(dataFile);
                this.println("\t=> rename temporary file to " + dataFile);
            }
            return;
        }
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if (temp) {
            file = tmpFile;
        } else {
            if (dataFile.exists()) {
                dataFile.delete();
            }
            file = dataFile;
        }
        try {
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int size = this.children.size();
            stream.writeUTF(this.lastBuildName(0));
            stream.writeInt(size);
            int i = 0;
            while (i < size) {
                ScenarioResults scenarioResults = (ScenarioResults)this.children.get(i);
                scenarioResults.write(stream);
                ++i;
            }
            stream.close();
            this.println("\t=> extracted data " + (temp ? "temporarily " : "") + "written in file " + file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("can't create output file" + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

