/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.results.ComponentResults;
import org.eclipse.test.internal.performance.results.PerformanceResults;

public abstract class AbstractResults
implements Comparable {
    private static final int ONE_MINUTE = 60000;
    private static final long ONE_HOUR = 3600000L;
    public static final Dim[] SUPPORTED_DIMS = new Dim[]{InternalDimensions.ELAPSED_PROCESS, InternalDimensions.CPU_TIME};
    static final int DEFAULT_DIM_INDEX = 0;
    public static final Dim DEFAULT_DIM = SUPPORTED_DIMS[0];
    public static final String[] CONFIGS;
    public static final String[] BOXES;
    protected static final SimpleDateFormat DATE_FORMAT;
    public static final String VERSION_REF;
    public static final String VERSION;
    AbstractResults parent;
    int id = -1;
    String name;
    List children;
    private static boolean NEW_LINE;
    PrintStream printStream = null;

    static {
        String descriptors = "Win XP Sun 1.5.0_10 (2 x 3.00GHz - 3GB RAM), SLED 10 Sun 1.5.0_10 (2 x 3.00GHz - 3GB RAM), RHEL 5.0 Sun 6.0_04 (2 x 3.00GHz - 3GB RAM)";
        StringTokenizer tokenizer = new StringTokenizer(descriptors, ",");
        ArrayList<String> boxes = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            boxes.add(tokenizer.nextToken().trim());
        }
        BOXES = new String[boxes.size()];
        boxes.toArray(BOXES);
        DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
        VERSION_REF = "R-3.4";
        VERSION = "3.5";
        CONFIGS = new String[]{"epwin2", "eplnx1", "eplnx2"};
        NEW_LINE = true;
    }

    public static boolean copyFile(File src, File dest) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getBuildDate(String buildName) {
        return AbstractResults.getBuildDate(buildName, VERSION_REF);
    }

    public static String getBuildDate(String buildName, String baselinePrefix) {
        if (baselinePrefix != null && buildName.startsWith(baselinePrefix)) {
            int length = buildName.length();
            return buildName.substring(length - 12, length);
        }
        char first = buildName.charAt(0);
        if (first == 'N' || first == 'I' || first == 'M') {
            return String.valueOf(buildName.substring(1, 9)) + buildName.substring(10, 14);
        }
        int length = buildName.length() - 12;
        int i = 0;
        while (i <= length) {
            try {
                String substring = i == 0 ? buildName : buildName.substring(i);
                DATE_FORMAT.parse(substring);
                return substring;
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        return null;
    }

    static Dim getDimension(int id) {
        int length = SUPPORTED_DIMS.length;
        int i = 0;
        while (i < length) {
            if (SUPPORTED_DIMS[i].getId() == id) {
                return SUPPORTED_DIMS[i];
            }
            ++i;
        }
        return null;
    }

    public static String timeString(long time) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(1);
        StringBuffer buffer = new StringBuffer();
        if (time < 100L) {
            buffer.append(time);
            buffer.append("ms");
        } else if (time < 1000L) {
            if (time % 100L != 0L) {
                format.setMaximumFractionDigits(2);
            }
            buffer.append(format.format((double)time / 1000.0));
            buffer.append("s");
        } else if (time < 60000L) {
            if (time % 1000L == 0L) {
                buffer.append(time / 1000L);
            } else {
                buffer.append(format.format((double)time / 1000.0));
            }
            buffer.append("s");
        } else if (time < 3600000L) {
            buffer.append(time / 60000L).append("mn ");
            long seconds = time % 60000L;
            buffer.append(seconds / 1000L);
            buffer.append("s");
        } else {
            long h = time / 3600000L;
            buffer.append(h).append("h ");
            long m = time % 3600000L / 60000L;
            buffer.append(m).append("mn ");
            long seconds = m % 60000L;
            buffer.append(seconds / 1000L);
            buffer.append("s");
        }
        return buffer.toString();
    }

    public static String timeChrono(long time) {
        if (time < 1000L) {
            return "00:00:00";
        }
        StringBuffer buffer = new StringBuffer();
        int seconds = (int)(time / 1000L);
        if (seconds < 60) {
            buffer.append("00:00:");
            if (seconds < 10) {
                buffer.append('0');
            }
            buffer.append(seconds);
        } else {
            int minutes = seconds / 60;
            if (minutes < 60) {
                buffer.append("00:");
                if (minutes < 10) {
                    buffer.append('0');
                }
                buffer.append(minutes);
                buffer.append(':');
                if ((seconds %= 60) < 10) {
                    buffer.append('0');
                }
                buffer.append(seconds);
            } else {
                int hours = minutes / 60;
                if (hours < 10) {
                    buffer.append('0');
                }
                buffer.append(hours);
                buffer.append(':');
                if ((minutes %= 60) < 10) {
                    buffer.append('0');
                }
                buffer.append(minutes);
                buffer.append(':');
                if ((seconds %= 60) < 10) {
                    buffer.append('0');
                }
                buffer.append(seconds);
            }
        }
        return buffer.toString();
    }

    public static String timeEnd(long time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(13, (int)(time / 1000L));
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("KK:mm:ss");
        return dateFormat.format(date);
    }

    AbstractResults(AbstractResults parent, String name) {
        this.parent = parent;
        this.children = new ArrayList();
        this.name = name;
    }

    AbstractResults(AbstractResults parent, int id) {
        this.parent = parent;
        this.children = new ArrayList();
        this.id = id;
    }

    void addChild(Comparable child, boolean sort) {
        if (sort) {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                Object results = this.children.get(i);
                if (child.compareTo(results) < 0) {
                    this.children.add(i, child);
                    return;
                }
                ++i;
            }
        }
        this.children.add(child);
    }

    public int compareTo(Object obj) {
        if (obj instanceof AbstractResults) {
            AbstractResults res = (AbstractResults)obj;
            return this.getName().compareTo(res.getName());
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractResults) {
            return this.name.equals(((AbstractResults)obj).getName());
        }
        return super.equals(obj);
    }

    public AbstractResults[] getChildren() {
        AbstractResults[] elements = new AbstractResults[this.size()];
        this.children.toArray(elements);
        return elements;
    }

    ComponentResults getComponentResults() {
        if (this.parent != null) {
            return this.parent.getComponentResults();
        }
        return null;
    }

    int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AbstractResults getParent() {
        return this.parent;
    }

    PerformanceResults getPerformance() {
        if (this.parent != null) {
            return this.parent.getPerformance();
        }
        return null;
    }

    String getPath() {
        String path = this.parent == null || this.parent.parent == null ? "" : String.valueOf(this.parent.getPath()) + ">";
        return String.valueOf(path) + this.name;
    }

    public Iterator getResults() {
        return this.children.iterator();
    }

    AbstractResults getResults(String resultName) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            AbstractResults searchedResults = (AbstractResults)this.children.get(i);
            if (searchedResults.getName().equals(resultName)) {
                return searchedResults;
            }
            ++i;
        }
        return null;
    }

    AbstractResults getResults(int searchedId) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            AbstractResults searchedResults = (AbstractResults)this.children.get(i);
            if (searchedResults.id == searchedId) {
                return searchedResults;
            }
            ++i;
        }
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    void printTab() {
        if (this.parent != null) {
            if (this.printStream != null) {
                this.printStream.print("\t");
            }
            this.parent.printTab();
        }
    }

    void print(String text) {
        if (this.printStream != null) {
            if (NEW_LINE) {
                this.printTab();
            }
            this.printStream.print(text);
            NEW_LINE = false;
        }
    }

    void printGlobalTime(long start) {
        this.printGlobalTime(start, null);
    }

    void printGlobalTime(long start, String end) {
        StringBuffer buffer;
        long time = System.currentTimeMillis();
        String resultsName = this.getName();
        if (resultsName == null) {
            buffer = new StringBuffer(" => time spent was ");
        } else {
            buffer = new StringBuffer(" => time spent in '");
            buffer.append(resultsName);
            buffer.append("' was ");
        }
        buffer.append(AbstractResults.timeString(time - start));
        if (end != null) {
            buffer.append(". ");
            buffer.append(end.trim());
        }
        this.println(buffer);
    }

    void println() {
        if (this.printStream != null) {
            this.printStream.println();
            NEW_LINE = true;
        }
    }

    void println(String text) {
        if (this.printStream != null) {
            if (NEW_LINE) {
                this.printTab();
            }
            this.printStream.println(text);
            NEW_LINE = true;
        }
    }

    void println(StringBuffer buffer) {
        this.println(buffer.toString());
    }

    public int size() {
        return this.children == null ? 0 : this.children.size();
    }

    public String toString() {
        return this.getPath();
    }
}

