/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.actionscript.ui.Messages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeployMainPage
extends WizardPage {
    Text fProjText;
    Text fMainText;
    IJavaProject project;
    IType[] types = null;
    private String projectName = null;
    private String mainTypeName = null;

    public DeployMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        layout.verticalSpacing = 0;
        composite.setLayoutData((Object)gd);
        this.createProjectEditor(composite);
        this.createMainTypeEditor(composite, Messages.DeployMainPage_0);
        this.setMessage(Messages.DeployMainPage_1);
        this.setPageComplete(this.isComplete());
        this.setControl((Control)composite);
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(Messages.DeployMainPage_2);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DeployMainPage.this.setPageComplete(DeployMainPage.this.isComplete());
            }
        });
        if (this.projectName != null) {
            this.fProjText.setText(this.projectName);
        }
        Button fProjButton = new Button((Composite)group, 8);
        fProjButton.setText(Messages.DeployMainPage_3);
        fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployMainPage.this.project = DeployMainPage.this.chooseJavaProject();
                if (DeployMainPage.this.project == null) {
                    return;
                }
                DeployMainPage.this.fProjText.setText(DeployMainPage.this.project.getElementName());
            }
        });
    }

    protected void createMainTypeEditor(Composite parent, String text) {
        Group mainGroup = new Group(parent, 0);
        mainGroup.setLayout((Layout)new GridLayout(2, false));
        mainGroup.setText(text);
        mainGroup.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        mainGroup.setLayoutData((Object)gd);
        this.fMainText = new Text((Composite)mainGroup, 2052);
        this.fMainText.setFont(parent.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fMainText.setLayoutData((Object)gd);
        if (this.mainTypeName != null) {
            this.fMainText.setText(this.mainTypeName);
        }
        this.fMainText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DeployMainPage.this.setPageComplete(DeployMainPage.this.isComplete());
            }
        });
        Button fSearchButton = new Button((Composite)mainGroup, 8);
        fSearchButton.setText(Messages.DeployMainPage_4);
        fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IJavaProject project = DeployMainPage.this.getJavaProject();
                IJavaElement[] elements = null;
                if (project == null || !project.exists()) {
                    IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    if (model != null) {
                        try {
                            elements = model.getJavaProjects();
                        }
                        catch (JavaModelException e1) {
                            JDIDebugUIPlugin.log((Throwable)e1);
                        }
                    }
                } else {
                    elements = new IJavaElement[]{project};
                }
                if (elements == null) {
                    elements = new IJavaElement[]{};
                }
                int constraints = 1;
                IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)(constraints |= 2));
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                DeployMainPage.this.types = engine.searchMainMethods((IProgressMonitor)new NullProgressMonitor(), searchScope, false);
                DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(DeployMainPage.this.getShell(), DeployMainPage.this.types, Messages.DeployMainPage_10);
                if (mmsd.open() == 1) {
                    return;
                }
                Object[] results = mmsd.getResult();
                IType type = (IType)results[0];
                if (type != null) {
                    DeployMainPage.this.fMainText.setText(type.getFullyQualifiedName());
                    DeployMainPage.this.fProjText.setText(type.getJavaProject().getElementName());
                }
            }
        });
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.DeployMainPage_5);
        dialog.setMessage(Messages.DeployMainPage_6);
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects());
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log((Throwable)jme);
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setTypes(IType[] types) {
        if (types.length > 1) {
            String name = null;
            IJavaProject tempProject = null;
            int i = 0;
            while (i < types.length) {
                tempProject = types[i].getJavaProject();
                String tempProjName = tempProject.getElementName();
                if (name == null) {
                    name = tempProjName;
                } else if (name != tempProjName) break;
                ++i;
            }
            this.projectName = name;
            this.project = tempProject;
        } else if (types.length == 1) {
            this.project = types[0].getJavaProject();
            this.projectName = this.project.getElementName();
            this.mainTypeName = types[0].getFullyQualifiedName();
        }
    }

    boolean isComplete() {
        if (this.fProjText == null || this.fMainText == null) {
            return false;
        }
        String path = this.fProjText.getText().trim();
        if (path.equals("")) {
            this.setErrorMessage(Messages.DeployMainPage_8);
            return false;
        }
        path = this.fMainText.getText().trim();
        if (path.equals("")) {
            this.setErrorMessage(Messages.DeployMainPage_10);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.DeployMainPage_1);
        return true;
    }
}

