/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ActionScriptPropertyTester
extends PropertyTester {
    private static final String PROPERTY_HAS_MAIN = "hasMain";
    private static final String PROPERTY_IS_CONTAINER = "isContainer";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IS_CONTAINER.equals(property)) {
            IResource resource;
            if (receiver instanceof IAdaptable && (resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null) {
                return resource instanceof IContainer;
            }
            return false;
        }
        IJavaElement element = null;
        if (receiver instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)receiver).getAdapter(IJavaElement.class)) != null && !element.exists()) {
            return false;
        }
        if (PROPERTY_HAS_MAIN.equals(property)) {
            return this.hasMain(element);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMain(IJavaElement element) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            if (!type.exists()) return false;
            if (this.hasMainMethod(type)) {
                return true;
            }
            IJavaElement[] children = type.getChildren();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (this.hasMainInChildren(this.getType(children[i]))) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isMainMethod()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IType getType(IJavaElement element) {
        IType type = null;
        if (element instanceof ICompilationUnit) {
            type = ((ICompilationUnit)element).findPrimaryType();
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }

    private boolean hasMainInChildren(IType type) throws CoreException {
        if (type.isClass() & Flags.isStatic((int)type.getFlags())) {
            if (this.hasMainMethod(type)) {
                return true;
            }
            IJavaElement[] children = type.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].getElementType() == 7) {
                    return this.hasMainInChildren((IType)children[i]);
                }
                ++i;
            }
        }
        return false;
    }
}

