/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.eclipse.swt.tools.actionscript.ui.ActionScriptUIPlugin;
import org.eclipse.swt.tools.actionscript.ui.Messages;
import org.eclipse.swt.widgets.Shell;

public class ActionScriptApplicationLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute("org.eclipse.swt.tools.actionscript.core.outputDirName", Messages.ActionScriptApplicationLaunchShortcut_0);
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)ActionScriptUIPlugin.getActiveWorkbenchShell(), (String)Messages.ActionScriptApplicationLaunchShortcut_1, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IType type;
            if (elements.length == 1 && (type = this.isMainMethod(elements[0])) != null) {
                return new IType[]{type};
            }
            IJavaElement[] javaElements = this.getJavaElements(elements);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)(constraints |= 2));
            return engine.searchMainMethods(context, scope, 0);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    private IType isMainMethod(Object o) {
        IAdaptable adapt;
        IJavaElement element;
        if (o instanceof IAdaptable && (element = (IJavaElement)(adapt = (IAdaptable)o).getAdapter(IJavaElement.class)) != null && element.getElementType() == 9) {
            try {
                IMethod method = (IMethod)element;
                if (method.isMainMethod()) {
                    return method.getDeclaringType();
                }
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
            }
        }
        return null;
    }

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            IJavaElement element;
            Object object = objects[i];
            if (object instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) != null) {
                IType type;
                if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                    element = type;
                }
                list.add(element);
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.swt.tools.actionscript.core.actionscriptApplication");
    }

    protected String getEditorEmptyMessage() {
        return Messages.ActionScriptApplicationLaunchShortcut_2;
    }

    protected String getSelectionEmptyMessage() {
        return Messages.ActionScriptApplicationLaunchShortcut_3;
    }

    protected String getTypeSelectionTitle() {
        return Messages.ActionScriptApplicationLaunchShortcut_4;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

