package org.eclipse.swt.tools.actionscript.ui;

import java.io.File;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class OutputPage extends WizardPage {
	Text outputText,crossdomainText, themeText;
	Button staticLinking, crossdomainOptions, themeOptions;

	public OutputPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}
	
	public void createControl(Composite parent) {
		Composite comp = new Composite(parent, SWT.NONE);
		comp.setLayout(new GridLayout(1, false));
		Group outputGroup = new Group(comp, SWT.NONE);
		outputGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		outputGroup.setText(Messages.OutputPage_0);
		outputGroup.setLayout(new GridLayout(2, false));
		outputText = new Text(outputGroup, SWT.SINGLE | SWT.BORDER);
		outputText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		outputText.addListener(SWT.Modify, new Listener() {
			public void handleEvent(Event event) {
				setPageComplete(isComplete());
			}
		});
		Button browseButton = new Button (outputGroup, SWT.PUSH);
		browseButton.setText(Messages.OutputPage_1);
		browseButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog d = new DirectoryDialog(getShell(), SWT.NONE);
				d.setText (Messages.OutputPage_2);
				outputText.setText(d.open ());
			}});
		
		Group linkGroup = new Group(comp, SWT.NONE);
		linkGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		linkGroup.setText(Messages.OutputPage_3);
		linkGroup.setLayout(new GridLayout(1, false));
		staticLinking = new Button(linkGroup, SWT.CHECK);
		staticLinking.setText(Messages.OutputPage_4);
		staticLinking.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		staticLinking.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateCheckState ();
				setPageComplete(isComplete());
			}});
		
		Group crossdomainGroup = new Group(comp, SWT.NONE);
		crossdomainGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		crossdomainGroup.setText(Messages.OutputPage_5);
		crossdomainGroup.setLayout(new GridLayout(1, false));
		crossdomainOptions = new Button(crossdomainGroup, SWT.CHECK);
		crossdomainOptions.setText(Messages.OutputPage_6);
		crossdomainOptions.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		crossdomainOptions.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateCheckState ();
				setPageComplete(isComplete());
			}});
		crossdomainText = new Text(crossdomainGroup, SWT.SINGLE | SWT.BORDER);
		crossdomainText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		themeOptions = new Button(crossdomainGroup, SWT.CHECK);
		themeOptions.setText("Use theme file at following location");
		themeOptions.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		themeOptions.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateCheckState ();
				setPageComplete(isComplete());
			}});
		themeText = new Text(crossdomainGroup, SWT.SINGLE | SWT.BORDER);
		themeText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		updateCheckState ();
		setMessage(Messages.OutputPage_10);
		setPageComplete(isComplete ());
		setControl(comp);
	}
	
	void updateCheckState () {
		crossdomainText.setEnabled(crossdomainOptions.getSelection());
		themeText.setEnabled(themeOptions.getSelection());
	}

	boolean isComplete () {
		String path = outputText.getText().trim();
		if(path.equals("")) { //$NON-NLS-1$
			setErrorMessage(Messages.OutputPage_8);
			return false;
		}
		if (!(new File(path)).isDirectory()) {
			setErrorMessage(Messages.OutputPage_9);
			return false;
		}
		setErrorMessage(null);
		setMessage(Messages.OutputPage_10);
		return true;
	}
}
