package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class ActionScriptPreferencePage extends PreferencePage implements
IWorkbenchPreferencePage {

	Button debugMode, showErrors;
	Text outputText;
	IWorkbench workbench;
	
	final boolean supportPrebuildSWC = false;
	
	protected Control createContents(Composite parent) {
		Composite comp = new Composite(parent, SWT.NONE);
		comp.setLayout(new GridLayout(1, false));
		
		Group outputGroup = new Group(comp, SWT.NONE);
		outputGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		outputGroup.setText(Messages.ActionScriptPreferencePage_0);
		outputGroup.setLayout(new GridLayout(1, false));
		
		debugMode = new Button(outputGroup, SWT.CHECK);
		debugMode.setText(Messages.ActionScriptPreferencePage_1);
		debugMode.addSelectionListener(new SelectionAdapter () {
			public void widgetSelected(SelectionEvent e) {
				updateApplyButton();
			}
		});
		
		showErrors = new Button(outputGroup, SWT.CHECK);
		showErrors.setText("Show compilation errors in ActionScript files");
		showErrors.addSelectionListener(new SelectionAdapter () {
			public void widgetSelected(SelectionEvent e) {
				updateApplyButton();
			}
		});
		
		if (supportPrebuildSWC) {
			//TODO: e4 This field is meant to enable users to compile against prebuilt SWCs. There is supporting
			//code already released in ActionScriptParticipant and ActionScriptLaunchConfigutationDelegate. The
			//issues remaining to be investigated are:
			// - classpath order matters (must know which projects depends on which and they might must be added in the right order)
			// - dependencies on host plugins cannot be resolved properly. Currently, the e4 SWT has a different structure from the
			//shipped version of SWT and this causes problems.
			Group swcPathGroup = new Group(comp, SWT.NONE);
			swcPathGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			swcPathGroup.setText(Messages.ActionScriptPreferencePage_2);
			swcPathGroup.setLayout(new GridLayout(2, false));
			outputText = new Text(swcPathGroup, SWT.SINGLE | SWT.BORDER);
			outputText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			
			Button browseButton = new Button (swcPathGroup, SWT.PUSH);
			browseButton.setText(Messages.ActionScriptOutputTab_1);
			browseButton.addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e) {
					DirectoryDialog dialog = new DirectoryDialog(workbench.getActiveWorkbenchWindow().getShell());
					String result = dialog.open();
					if (result == null) return;
					outputText.setText(result);
					updateApplyButton();
				}});
		}
		
		initialize();
		return comp;
	}

	public void init(IWorkbench workbench) {
		this.workbench = workbench;
	}
	
	private void initialize() {
		IPreferencesService service = Platform.getPreferencesService();
		debugMode.setSelection(service.getBoolean(ActionScriptCorePlugin.PLUGIN_ID, ActionScriptCorePlugin.PREF_ENABLE_DEBUG_CHECK, false, null));
		showErrors.setSelection(service.getBoolean(ActionScriptCorePlugin.PLUGIN_ID, ActionScriptCorePlugin.PREF_SHOW_ACTIONSCRIPT_ERRORS, false, null));
		if (supportPrebuildSWC) outputText.setText(service.getString(ActionScriptCorePlugin.PLUGIN_ID, ActionScriptCorePlugin.PREF_SWC_PATH, "", null)); //$NON-NLS-1$
	}
	
	
	public boolean performOk() {
		IEclipsePreferences instanceNode = (IEclipsePreferences) new InstanceScope().getNode(ActionScriptCorePlugin.PLUGIN_ID);
		instanceNode.putBoolean(ActionScriptCorePlugin.PREF_ENABLE_DEBUG_CHECK, debugMode.getSelection());
		instanceNode.putBoolean(ActionScriptCorePlugin.PREF_SHOW_ACTIONSCRIPT_ERRORS, showErrors.getSelection());
		if (supportPrebuildSWC) instanceNode.put(ActionScriptCorePlugin.PREF_SWC_PATH, outputText.getText());
		try {
			instanceNode.flush();
		} catch (BackingStoreException e) {
			e.printStackTrace();
		}
		return true;
	}
	protected void performDefaults() {
		super.performDefaults();
		debugMode.setSelection(true);
		showErrors.setSelection(false);
		if (supportPrebuildSWC) outputText.setText(""); //$NON-NLS-1$
	}

}
