/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ActionScriptOutputTab extends AbstractLaunchConfigurationTab {
	
	Text outputText, themeText;
	Button staticLinking, themeOptions;
	
	public void createControl(Composite parent) {
		Composite comp = new Composite(parent, SWT.NONE);
		comp.setLayout(new GridLayout(1, false));
		
		Group outputGroup = new Group(comp, SWT.NONE);
		outputGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		outputGroup.setText(Messages.ActionScriptOutputTab_0);
		outputGroup.setLayout(new GridLayout(2, false));
		outputText = new Text(outputGroup, SWT.SINGLE | SWT.BORDER);
		outputText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		outputText.addListener(SWT.Modify, new Listener() {
			public void handleEvent(Event event) {
				updateLaunchConfigurationDialog();
			}
		});
		Button browseButton = new Button (outputGroup, SWT.PUSH);
		browseButton.setText(Messages.ActionScriptOutputTab_1);
		browseButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				
			}});
		
		Group linkGroup = new Group(comp, SWT.NONE);
		linkGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		linkGroup.setText(Messages.ActionScriptOutputTab_2);
		linkGroup.setLayout(new GridLayout(1, false));
		staticLinking = new Button(linkGroup, SWT.CHECK);
		staticLinking.setText(Messages.ActionScriptOutputTab_3);
		staticLinking.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		staticLinking.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateLaunchConfigurationDialog();
			}});
		
		Group crossdomainGroup = new Group(comp, SWT.NONE);
		crossdomainGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		crossdomainGroup.setText("Theme");
		crossdomainGroup.setLayout(new GridLayout(1, false));
		themeOptions = new Button(crossdomainGroup, SWT.CHECK);
		themeOptions.setText("Use theme file at following location");
		themeOptions.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		themeOptions.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateLaunchConfigurationDialog ();
			}});
		themeText = new Text(crossdomainGroup, SWT.SINGLE | SWT.BORDER);
		themeText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setControl(comp);

	}

	public String getName() {
		return Messages.ActionScriptOutputTab_4;
	}

	public void initializeFrom(ILaunchConfiguration config) {
		updateFromConfig(config);
	}

	private void updateFromConfig(ILaunchConfiguration config) {
		try {
			outputText.setText(config.getAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_OUTPUT_DIR_NAME, "")); //$NON-NLS-1$
			staticLinking.setSelection(config.getAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_STATIC_LINK_OPTION, false));
			themeOptions.setSelection(config.getAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_THEME_OPTION, false));
			themeText.setText(config.getAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_THEME_PATH, "")); //$NON-NLS-1$
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
	}

	public void performApply(ILaunchConfigurationWorkingCopy config) {
		config.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_OUTPUT_DIR_NAME, outputText.getText().trim());
		config.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_STATIC_LINK_OPTION, staticLinking.getSelection());
		config.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_THEME_OPTION, themeOptions.getSelection());
		config.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_THEME_PATH, themeText.getText().trim());
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy config) {
		initializeOutputDir(config);
	}
	
	private void initializeOutputDir(ILaunchConfigurationWorkingCopy config) {
		config.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_OUTPUT_DIR_NAME, Messages.ActionScriptOutputTab_6);
	}

	/**
	 * Convenience method to get the workspace root.
	 */
	protected IWorkspaceRoot getWorkspaceRoot() {
		return ResourcesPlugin.getWorkspace().getRoot();
	}

	/**
	 * Returns the current Java element context in the active workbench page
	 * or <code>null</code> if none.
	 * 
	 * @return current Java element in the active page or <code>null</code>
	 */
	protected IJavaElement getContext() {
		IWorkbenchPage page = getActivePage();
		if (page != null) {
			ISelection selection = page.getSelection();
			if (selection instanceof IStructuredSelection) {
				IStructuredSelection ss = (IStructuredSelection)selection;
				if (!ss.isEmpty()) {
					Object obj = ss.getFirstElement();
					if (obj instanceof IJavaElement) {
						return (IJavaElement)obj;
					}
					if (obj instanceof IResource) {
						IJavaElement je = JavaCore.create((IResource)obj);
						if (je == null) {
							IProject pro = ((IResource)obj).getProject();
							je = JavaCore.create(pro);
						}
						if (je != null) {
							return je;
						}
					}
				}
			}
			IEditorPart part = page.getActiveEditor();
			if (part != null) {
				IEditorInput input = part.getEditorInput();
				return (IJavaElement) input.getAdapter(IJavaElement.class);
			}
		}
		return null;
	}

	/**
	 * Returns the active workbench window
	 * 
	 * @return the active workbench window
	 */
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return ActionScriptUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
	}	
	
	public static IWorkbenchPage getActivePage() {
		IWorkbenchWindow w = getActiveWorkbenchWindow();
		if (w != null) {
			return w.getActivePage();
		}
		return null;
	}
	

	

}
