package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ActionScriptDeployWizard extends Wizard implements IExportWizard {
	DeployMainPage mainPage;
	OutputPage outputPage;
	IStructuredSelection selection;
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
			this.selection = selection;
	}

	public void addPages() {
		ActionScriptApplicationLaunchShortcut sc = new ActionScriptApplicationLaunchShortcut ();
		IType[] types = null;
		try {
			types = sc.findTypes(selection.toArray(), PlatformUI.getWorkbench().getProgressService ());
		} catch (InterruptedException e) {
			MessageDialog.openError(ActionScriptUIPlugin.getActiveWorkbenchShell (), Messages.ActionScriptApplicationLaunchShortcut_1, e.getMessage ());
		} catch (CoreException e) {
			MessageDialog.openError(ActionScriptUIPlugin.getActiveWorkbenchShell (), Messages.ActionScriptApplicationLaunchShortcut_1, e.getStatus ().getMessage ());	
		}
		mainPage = new DeployMainPage(Messages.ActionScriptDeployWizard_3, Messages.ActionScriptDeployWizard_0, null);  
		addPage(mainPage);
		mainPage.setTypes(types);
		outputPage = new OutputPage(Messages.ActionScriptDeployWizard_1, Messages.ActionScriptDeployWizard_2, null);
		addPage(outputPage);
	}

	public boolean performFinish() {
		if (!canFinish ()) return false;
		ActionScriptLaunchConfigurationDelegate delegate = new ActionScriptLaunchConfigurationDelegate ();
		IJavaProject project = mainPage.project;
		String mainClass = mainPage.fMainText.getText ();
		String outputDir = outputPage.outputText.getText ();
		ActionScriptCorePlugin.DEPLOY = true;
		ActionScriptCorePlugin.DEPLOY_URL = outputDir;
		ActionScriptCorePlugin.CROSS_DOMAIN = outputPage.crossdomainOptions.getSelection ();
		if (ActionScriptCorePlugin.CROSS_DOMAIN) {
			ActionScriptCorePlugin.CROSS_DOMAIN_URL = outputPage.crossdomainText.getText ();
		}
		ActionScriptCorePlugin.THEME = outputPage.themeOptions.getSelection ();
		if (ActionScriptCorePlugin.THEME) {
			ActionScriptCorePlugin.THEME_URL = outputPage.themeText.getText ();
		}
		try {
			delegate.generateSWFFiles(project,mainClass, outputDir);
			boolean staticLinking = outputPage.staticLinking.getSelection ();
			delegate.generateSWF (project, mainClass, outputDir, null, staticLinking);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return true;
	}
}
