package org.eclipse.swt.tools.actionscript.ui;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.actionscript.build.IActionScriptConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ActionScriptBuildConsole extends MessageConsole implements IActionScriptConsole {
	
	public final static String CONSOLE_TYPE = "actionscriptBuildConsole"; //$NON-NLS-1$

	MessageConsoleStream outputStream;
	MessageConsoleStream errorStream;
	public ActionScriptBuildConsole() {
		super(Messages.ActionScriptBuildConsole_0, CONSOLE_TYPE, null, true);
	}

	protected void init() {
		super.init();
		outputStream = newMessageStream();
		errorStream = newMessageStream();
		errorStream.setColor(ActionScriptUIPlugin.getActiveWorkbenchShell().getDisplay().getSystemColor(SWT.COLOR_RED));
	}

	public void appendText (String buffer, boolean isError) {
		try {
			(isError ? errorStream : outputStream ).write(buffer);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
    
}
